
<link rel="STYLESHEET" type="text/css" href="common/dhtmlx/dhtmlx.css">
<link href="common/styles/english_style.css" rel="stylesheet" type="text/css">
<script language="JavaScript" type="text/javascript" src="common/dhtmlx/dhtmlx.js"></script>
<script language="JavaScript" type="text/javascript" src="common/dhtmlx/interact.js"></script>
<script src="common/autocomplete/jquery-1.10.2.js"></script>
<script src="common/autocomplete/jquery-ui.js"></script>

<link rel="STYLESHEET" type="text/css" href="common/fontawesome/css/all.css">
<link rel="STYLESHEET" type="text/css" href="common/styles/responsive/style.css">
<script language="JavaScript">
var postalGrid, mylayout;
function loadBankAccount()
{
	
	mylayout = new dhtmlXLayoutObject('gridbox','1C');
	mylayout.cells("a").hideHeader();
    postalGrid = mylayout.cells("a").attachGrid();
    postalGrid.setImagePath("common/dhtmlx/imgs/dhxgrid_skyblue/");
    postalGrid.setHeader("Action,Bank Name ,Area,Zone, Branch,Account No,Status");
    postalGrid.setInitWidthsP("10,10,10,10,10,10,10");
    postalGrid.setColAlign("center,left,left,left,left,left,left");
    postalGrid.setColTypes("ro,ro,ro,ro,ro,ro,ro");
    postalGrid.setColumnColor("#E0E0E0");
    postalGrid.enablePaging(true, "10", "dhx_skyblue", "pagingArea", true, "infoArea");
    postalGrid.setPagingSkin("bricks");
    postalGrid.enableCollSpan(true);
    postalGrid.setSkin("dhx_skyblue");
    postalGrid.attachEvent("onXLS",function() {mylayout.cells("a").progressOn();})
    postalGrid.attachEvent("onXLE",function() {mylayout.cells("a").progressOff();})
    postalGrid.attachEvent("onMouseOver",function(row_id,cell_index){cell_index > 0 ? true:false;});
    postalGrid.init();
    postalGrid.load("?c=settings&m=bank_account_details");
}

function reloadGrid()
{
    str = "?c=settings&m=bank_account_details";
    postalGrid.clearAndLoad(str);
	
}
function btnStatus(flag) {

    if (flag) {
        document.form1.Update.disabled = false;
        document.form1.Add.disabled = true;
     
    } else {
        document.form1.Update.disabled = true;
        document.form1.Add.disabled = false;
      
    }

}
function ResetFields() {
    $j("#bank_account_form").trigger("reset");
    $j("#bank_account_id").val('');
    btnStatus();
}
function insertUpdateBankAccount() {
    if (validateFields()) {
        $j.ajax({
            url: '?c=settings&m=insertUpdateBankAccount',
            type: 'post',
            dataType: 'json',
			
            data: "action=insertUpdateBankAccount&" +  $j("#bank_account_form").serialize(),//{data:$j("#bank_form").serialize()},
            success: function (data) {
                if (data.status == "fail") {
                    errorMsg(data.error, function () {
                        $j('#bank_account_id').val('');
                    });
                    return false;
                }
                else{
                    scroll(0, 0);
                    reloadGrid();
                    btnStatus();
                    successMsg(data.message);
                    ResetFields();
                    return true;
                }
            }
        });

        return true;
    }
}
function validateFields() {
    var field_list = Array("account_id", "zone_id","area_id","branch_id","txt_account_no");
    var field_list_names = Array("Bank ", "Zone","Area","Branch","Account No");
    for (i = 0; i < field_list.length; i++) {
        if (!isNullFields(eval("document.form1." + field_list[i]), field_list_names[i], field_list_names[i]))
            return false;
    }
    return true;
}
function isNullFields(obj, fldName) {
    if (LTrim(obj.value) == "") {
        errorMsg(ucFirst(fldName.replace("_", " ").replace("_", " ").replace("_", " ").replace("_", " ")) + " Cannot Be Empty!", function () {
            obj.focus();
        });
        return false;
    }

    return true;
}
function LTrim(value) {
    var re = /\s*((\S+\s*)*)/;
    return value.replace(re, "$1");
}
function ucFirst(str) {
    return str.toLowerCase().replace(/\b([a-z])/gi, function (c) {
        return c.toUpperCase()
    });
}
function deleteBankAccount(id) {

        if (confirm("Are you sure you want to delete this Bank Account?")) {
            $j.ajax({
                url: '?c=settings&m=delete_bank_account',
                type: 'post',
                dataType: 'json',
                data: {'id':id},
                success: function (data) {
                    if (data.status == "success") {
                        successMsg(data.message);
                        reloadGrid();
                        btnStatus();
                    }
					else{
                        errorMsg(data.message);
                        reloadGrid();
                        btnStatus();
                    }
                }
            });

        }


}
function editBankAccount  (rowId) {
	$j('html, body').animate({
         scrollTop: $j("#bank_account_form").offset().top
     }, 400);
	 const status = postalGrid.getUserData(rowId, "status");
	// alert(status);
	//alert(postalGrid.getUserData(rowId, "status"));
	  const account_id = postalGrid.getUserData(rowId, "account_id");
    $j("#bank_account_id").val(rowId);
	//alert(postalGrid.getUserData(rowId, "area_id"))
    $j("#account_id").val(account_id);
    $j("#zone_id").val(postalGrid.getUserData(rowId, "zone_id"));
	common.load_area($j('#zone_id'));
	$j("#area_id").val(postalGrid.getUserData(rowId, "area_id"));
	common.load_branch($j('#area_id'));
	$j("#branch_id").val(postalGrid.getUserData(rowId, "branch_id"));
	$j("#txt_account_no").val(postalGrid.cells(rowId, 5).getValue());
	$j("#status_active").val(postalGrid.getUserData(rowId, "status"));
    btnStatus(true);
}	

</script>

	<div style="padding: 9px; width: 98%;margin:0 auto;text-align:center" class="layer">
		<div id="bank_form1">
<!-- -->
<form name="form1" id="bank_account_form" method="post" enctype="multipart/form-data">
<input type="hidden" name="bank_account_id" id="bank_account_id" value="<?php echo $_REQUEST['id'];?>">
<table width="96%" border="0" align="center" cellpadding="2" cellspacing="2">

	<tr><td height="20" valign="top" class="PageTitle1">Bank Account</td></tr>
<tr>
	<td align="center" style="padding-top:8px">
		<div id="gridbox" style="width:100%;height:450px;min-height:450px;"></div>
		<div><span id="pagingArea"></span>&nbsp;<span id="infoArea"></span></div>
		<span id="recfound"></span></td>
</tr>
	
<tr>
	<td height="35" align="left" valign="top">
	<fieldset style="width:100%; padding:10px 10px 10px 10px;background:white;text-align:left">
	<legend class="BlueListFont" style="text-align:left!important">Bank Account Information</legend>
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td width="20%" height="27" class="Mandatory">Select Bank</td>
		<td width="80%" class="FormLabel" colspan="3"><select style="width:400px" name="account_id" id="account_id" class="combo_boxes">
				<?php echo common::get_bank_list();?>
		</select>
		</td>
	</tr> 
	<tr>
		<td width="20%" height="27" class="Mandatory">Zone</td>
		<td width="30%" class="FormLabel"><select style="width:130px" name="zone_id" id="zone_id" class="combo_boxes">
				<?php echo common::get_zone_list($user['zone_id']);?>
		</select>
		</td>
		<td width="20%" height="27" class="FormLabel">Area</td>
		<td width="30%" class="FormLabel"><select style="width:130px" name="area_id" id="area_id" class="combo_boxes">
					<option value="">[Area]</option>
			</select></td>
	</tr> 
	<tr>
	  
		<td width="20%" height="27" class="FormLabel">Branch</td>
		<td width="30%" class="FormLabel"><select style="width:130px" name="branch_id" id="branch_id" class="combo_boxes">
					<option value="">[Branch]</option>
			</select></td>
		<td height="27" class="Mandatory">Account No</td>
		<td class="FormLabel">
		<input type="text" name="txt_account_no" id="txt_account_no"  class="text_boxes" style="width:130px" onkeypress="return numbersonly(this,event)"  />
 		</td>
	
	  </tr>
	
	<tr>
		
		<td height="27" class="FormLabel">Status</td>
		<td class="FormLabel"><select name="status_active" id="status_active" class="TextBox" style="width:120px" >
		<option value="1" >Active</option>
		<option value="0">Inactive</option>
		</select></td>
		<td class="FormLabel"></td>
		<td class="FormLabel"></td>		
	</tr>		
	</table>
	</fieldset>
	</td>
</tr>
</table>

<table width="96%" border="0" cellspacing="0" cellpadding="0" align="center">	
<tr class="FormLabel"> 
	<td colspan="2" align="center" valign="middle" style="padding:25px 0px 25px 0px">
        
	<table border="0" cellspacing="0" cellpadding="0">
		<tr align="center">
			<td width="80"><input type="button" class="Fbuttons" onMouseOver="this.className = 'fbuttonshover'" onMouseOut="this.className = 'Fbuttons';" onMouseDown="this.className = 'fbuttonsfocusactive';"name="New" value="New" tabindex="35" class="FButtons" onClick="javascript:ResetFields()" ></td>
			<td width="80"><input type="button" class="Fbuttons" onMouseOver="this.className = 'fbuttonshover'" onMouseOut="this.className = 'Fbuttons';" onMouseDown="this.className = 'fbuttonsfocusactive';"name="Add" value="Add" tabindex="35" class="FButtons" onClick="javascript:insertUpdateBankAccount()"></td>
			<td width="80"><input type="button" class="Fbuttons" onMouseOver="this.className = 'fbuttonshover'" onMouseOut="this.className = 'Fbuttons';" onMouseDown="this.className = 'fbuttonsfocusactive';"name="Update" value="Update" tabindex="35" class="FButtons" onClick="javascript:insertUpdateBankAccount()" disabled="true"></td>
		</tr>
	</table>
      
	</td>
</tr>
</table>

</form>
</div>
 		</div>
	</div>
<script type="text/javascript">
	loadBankAccount();
	btnStatus();
</script>
	