<?php
class common {
    public static function redirect() {
        $CI = & get_instance();
        $uri = $CI->session->userdata('cur_uri');
        if ($uri == '')
            $uri = 'home';
        redirect($uri);
    }
    public static function track_uri() {
        $CI = & get_instance();
        $uri = $CI->uri->uri_string();
        $CI->session->set_userdata('cur_uri', $uri);
    }

    public static function is_logged_in() {
        $CI = & get_instance();
        if ($CI->session->userdata('logged_in')) {
            return true;
        } else {
            return false;
        }
    }

    public static function is_admin_logged() {
        $CI = & get_instance();
        if ($CI->session->userdata('logged_in') && $CI->session->userdata('user_name') == 'admin') {
            return true;
        } else {
            return false;
        }
    }

    public static function is_user_logged() {
        $CI = & get_instance();
        if ($CI->session->userdata('logged_in')) {
            return true;
        } else {
            return false;
        }
    }
	
    public static function is_logged() {
        $CI = & get_instance();
		if(!common::checkMac()){
			$CI = & get_instance();
			$CI->load->view("errors/html/error_device");exit;
		}
       else if (!$CI->session->userdata('logged_in')) {
            redirect('?c=login');
        }
    }

    public static function get_settings_data() {
        $data = null;
        $rows = sql::rows('settings');
        if (count($rows) > 0) {
            foreach ($rows as $row) {
                $data[$row['key_flag']] = $row['key_value'];
            }
        }
        return $data;
    }

    public static function pr($arr=array()) {
        if (is_array($arr)) {
            echo '<pre>';
            print_r($arr);
            echo '<pre>';
        }
    }

    public static function check_permission($action='view', $option='product', $user_id='') {
		return true;
        $CI = & get_instance();
        if ($user_id == '') {
            $user_id = $CI->session->userdata('user_id');
            if ($CI->session->userdata('user_name') == 'admin') {
                return TRUE;
            }
        }

        $sql = $CI->db->query("select $option from users where user_id='$user_id'");
        $per = $sql->row_array();
        $permit = explode("|", $per[$option]);
        if ($action == 'view') {
            if (in_array(1, $permit)) {
                return true;
            } else {
                return false;
            }
        }
        if ($action == 'add') {
            if (in_array(2, $permit)) {
                return true;
            } else {
                return false;
            }
        }
        if ($action == 'edit') {
            if (in_array(3, $permit)) {
                return true;
            } else {
                return false;
            }
        }
        if ($action == 'delete') {
            if (in_array(4, $permit)) {
                return true;
            } else {
                return false;
            }
        }
    }
public static function sending_mail($from_name, $from_email, $to_email, $subject, $msg_content,$attach='') {
        $CI = & get_instance();
        $CI->load->library('email');
        $config['protocol'] = 'sendmail';
        $config['mailpath'] = '/usr/sbin/sendmail';
        $config['charset'] = 'utf-8';
        $config['wordwrap'] = TRUE;
        $config['mailtype'] = 'html';

        $CI->email->initialize($config);

        $CI->email->from('sumon.sustcse@gmail.com', $from_name);
        $CI->email->to($to_email);
        $CI->email->subject($subject);
        $CI->email->message($msg_content);
		if($attach)
		$CI->email->attach($attach);
        $CI->email->send();
    }
	public static function get_account_list($sel='',$center_id='') {
        $CI = &get_instance();
		$con="";
		$str="<option value=''>[Bank]</option>";
		if($center_id){
			$con.=" and center_id='{$center_id}'";
		}
		$bank=sql::rows("lib_bank");	
		if(count($bank)>0){
			foreach($bank as $b){
				$str.='<optgroup label="'.$b['bank_name'].'">';
				$query = $CI->db->query("select * from lib_bank_account where 1 and account_id='{$b['id']}' $con order by account_no asc ");
				foreach ($query->result_array() as $u) {
					if ($sel == $u['id']) {
						$str.="<option value='" . $u['id'] . "' selected>--" . $u['account_no'] . "</option>";
					} else {
						$str.="<option value='" . $u['id'] . "' >--" . $u['account_no'] . "</option>";
					}
				}
				$str.="</optgroup>";
			}
		}
		return $str;
	}
	public static function get_center_list_for_multiple($sel='',$branch_id='') {
        $CI = &get_instance();
		$con="";
		if($branch_id)
			$con=" and branch_id='{$branch_id}'";
		$branch=sql::rows("branch");	
		if(count($branch)>0){
			foreach($branch as $b){
				$str.='<optgroup label="'.$b['branch_name'].'">';
				$query = $CI->db->query("select * from center where 1 and branch_id='{$b['branch_id']}' order by center_no asc");
				foreach ($query->result_array() as $u) {
					$name=$u['center_no']. '( '.$u['center_name'];
					if ($sel == $u['center_id']) {
						$str.="<option value='" . $u['center_id'] . "' selected>" . $name . ")</option>";
					} else {
						$str.="<option value='" . $u['center_id'] . "' >" . $name . ")</option>";
					}
				}
				$str.="</optgroup>";
			}
		}
       /* $query = $CI->db->query("select * from center where 1 $con order by center_no asc");
        foreach ($query->result_array() as $u) {
			$name=$u['center_no']. '( '.$u['center_name'];
			
            if ($sel == $u['center_id']) {
                $str.="<option value='" . $u['center_id'] . "' selected>" . $name . ")</option>";
            } else {
                $str.="<option value='" . $u['center_id'] . "' >" . $name . ")</option>";
            }
        }*/
        return $str;
    }
	public static function get_user_role_list($sel='') {
        $CI = &get_instance();
		$con="";
        $query = $CI->db->query("select * from user_role where 1  order by role_name asc");
        foreach ($query->result_array() as $u) {
            if ($sel == $u['role_id']) {
                $str.="<option value='" . $u['role_id'] . "' selected>" . $u['role_name'] . ")</option>";
            } else {
                $str.="<option value='" . $u['role_id'] . "' >" . $u['role_name'] . ")</option>";
            }
        }
        return $str;
    }
	public static function get_member_black_list_reason_list($sel='') {
        $CI = &get_instance();
		$con="";
		
        $query = $CI->db->query("select * from member_black_list_reason where 1 and status=1 order by reason_name asc");
        foreach ($query->result_array() as $u) {
            if ($sel == $u['reason_id']) {
                $str.="<option value='" . $u['reason_id'] . "' selected>" . $u['reason_name'] . ")</option>";
            } else {
                $str.="<option value='" . $u['reason_id'] . "' >" . $u['reason_name'] . ")</option>";
            }
        }
        return $str;
    }
	public static function get_designation_list($sel='') {
        $CI = &get_instance();
		$con="";
        $query = $CI->db->query("select * from designation where 1  order by title asc");
        foreach ($query->result_array() as $u) {
            if ($sel == $u['id']) {
                $str.="<option value='" . $u['id'] . "' selected>" . $u['title'] . ")</option>";
            } else {
                $str.="<option value='" . $u['id'] . "' >" . $u['title'] . ")</option>";
            }
        }
        return $str;
    }
	public static function get_center_list($sel='',$branch_id='') {
        $CI = &get_instance();
		$con="";
		if($branch_id)
			$con.=" and branch_id='{$branch_id}'";
		if(!common::is_super()&&$CI->session->userdata("center_id")!=""){
			$con.=" and center_id in(".$CI->session->userdata("center_id").")";
		}
		$str="<option value=''>[Center]</option>";
        $query = $CI->db->query("select * from center where 1 $con order by center_no asc");
        foreach ($query->result_array() as $u) {
			$name=$u['center_no']. '( '.$u['center_name'];
			if($u['center_name_in_bangla'])
				$name.='-'.$u['center_name_in_bangla'];
            if ($sel == $u['center_id']) {
                $str.="<option value='" . $u['center_id'] . "' selected>" . $name . ")</option>";
            } else {
                $str.="<option value='" . $u['center_id'] . "' >" . $name . ")</option>";
            }
        }
        return $str;
    }
	public static function check_uniqueness( $unique_field_name, $table_name, $query, $id='') {
		 $CI = &get_instance();
	$sql = "SELECT $unique_field_name FROM $table_name WHERE $query AND is_deleted = 0 AND status_active = 1";
	if( $id != '' ) $sql .= " AND id != $id";
	
	$sql_exe = $CI->db->query( $sql );
	$sql_rslt =$sql_exe->row_array();
	
	if( $sql_rslt[$unique_field_name] ) return false;
	else return true;
}
public static function return_field_value($fdata,$tdata,$cdata){
	$CI = &get_instance();
	 $sql_data="select $fdata from  $tdata where $cdata";
	$sql_data_exe=$CI->db->query($sql_data);
	$sql_data_rslt=$sql_data_exe->row_array();
	$m_data  = $sql_data_rslt[$fdata];
	return $m_data ;
}
	public static function return_next_id( $id_field_name, $table_name ) {
	$CI = &get_instance();
	$sql = $CI->db->query("SELECT MAX( $id_field_name ) as id FROM $table_name ORDER BY $id_field_name DESC");
	//$sql_exe = mysql_query( $sql );
	$sql_rslt = $sql->row_array();
	$next_id = $sql_rslt['id'] + 1;
	return $next_id;
}
public static function get_zone_list($sel='') {
        $CI = &get_instance();
		$con="";
        $query = $CI->db->query("select * from zone where  status=1 order by zone_name asc");
		$str="<option value=''>[zone]</option>";
        foreach ($query->result_array() as $u) {
			$name=$u['zone_name'];
			if($u['zone_name_in_bangla'])
				$name.='('.$u['zone_name_in_bangla'].')';
            if ($sel == $u['zone_id']) {
                $str.="<option value='" . $u['zone_id'] . "' selected>" . $name . "</option>";
            } else {
                $str.="<option value='" . $u['zone_id'] . "' >" . $name . "</option>";
            }
        }
        return $str;
    }
	public static function zone_list_array($param='name'){
		$zone_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT zone_id,zone_no, zone_name FROM  zone WHERE 1 ORDER BY zone_name ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$zone_chart[$row['zone_id']] = $row['zone_name'];
				else{
					$zone_chart[$row['zone_id']] = $row['zone_no'];
				}
			}
		}
		return $zone_chart;
	}
	public static function area_list_array($param='name'){
		$area_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT area_id,area_no, area_name FROM  area WHERE 1 ORDER BY area_name ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$area_chart[$row['area_id']] = $row['area_name'];
				else{
					$area_chart[$row['area_id']] = $row['area_no'];
				}
			}
		}
		return $area_chart;
	}
	public static function get_area_list($sel='',$zone_id=''){
		$CI = &get_instance();
		$con="";
		if($zone_id)
			$con=" and zone_id='{$zone_id}'";
        $query = $CI->db->query("select * from area where  status=1 $con order by area_name asc");
		$str="<option value=''>[Area]</option>";
        foreach ($query->result_array() as $u) {
			$name=$u['area_name'];
			if($u['area_name_in_bangla'])
				$name.='('.$u['area_name_in_bangla'].')';
            if ($sel == $u['area_id']) {
                $str.="<option value='" . $u['area_id'] . "' selected>" . $name . "</option>";
            } else {
                $str.="<option value='" . $u['area_id'] . "' >" . $name . "</option>";
            }
        }
        return $str;
	}
	public static function get_branch_list($sel='',$area_id=''){
		
		$CI = &get_instance();
		$con="";
		if(!common::is_super()){
			$con.=" and branch_id in('".$CI->session->userdata("branch_id")."')";
		}
		if($area_id)
			$con.=" and area_id='{$area_id}'";
         $query = $CI->db->query("select * from branch where  status=1 $con order by branch_name asc");
		$str="<option value=''>[Branch]</option>";
        foreach ($query->result_array() as $u) {
			$name=$u['branch_name'];
			if($u['branch_name_in_bangla'])
				$name.='('.$u['branch_name_in_bangla'].')';
            if ($sel == $u['branch_id']) {
                $str.="<option value='" . $u['branch_id'] . "' selected>" . $name . "</option>";
            } else {
                $str.="<option value='" . $u['branch_id'] . "' >" . $name . "</option>";
            }
        }
        return $str;
	}
	public static function staff_list($sel=''){
		$head_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT staff_id,full_name,staff_no FROM  staff WHERE 1  and status=1 ORDER BY full_name ASC");
		$rows=$query->result_array();
		 foreach ($query->result_array() as $u) {
            if ($sel == $u['staff_id']) {
                $str.="<option value='" . $u['staff_id'] . "' selected><b>" . $u['full_name'] ."</b>-". $u['staff_no']."</option>";
            } else {
                $str.="<option value='" . $u['staff_id'] . "' ><b>" . $u['full_name'] ."</b>-". $u['staff_no']."</option>";
            }
        }
		return $str;
	}
	public static function staff_list_by_branch($branch_id='',$sel=''){
		$head_chart = array();
		$CI = &get_instance();
		$con="  and branch_id='{$branch_id}'";
		$query=$CI->db->query("SELECT staff_id,full_name,staff_no FROM  staff WHERE 1  and status=1 $con ORDER BY full_name ASC");
		//echo $CI->db->last_query();exit;
		$rows=$query->result_array();
		$str="<option value=''>[All]</option>";
		 foreach ($query->result_array() as $u) {
            if ($sel == $u['staff_id']) {
                $str.="<option value='" . $u['staff_id'] . "' selected><b>" . $u['full_name'] ."</b>-". $u['staff_no']."</option>";
            } else {
                $str.="<option value='" . $u['staff_id'] . "' ><b>" . $u['full_name'] ."</b>-". $u['staff_no']."</option>";
            }
        }
		return $str;
	}
	public static function get_staff_id($center_id){
		if($center_id=='')
			return false;
		else{
			$row=sql::row("staff_center","center_id='{$center_id}' and status=1","staff_id");
			return $row['staff_id'];
		}
	} 
	public static function income_head_list_array($param='name'){
		$head_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT id,title FROM  income_head WHERE 1 ORDER BY title ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$head_chart[$row['id']] = $row['title'];
				else{
					$head_chart[$row['id']] = $row['id'];
				}
			}
		}
		return $head_chart;
	}
	public static function expense_head_list_array($param='name'){
		$head_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT id,title FROM  expense_head WHERE 1 ORDER BY title ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$head_chart[$row['id']] = $row['title'];
				else{
					$head_chart[$row['id']] = $row['id'];
				}
			}
		}
		return $head_chart;
	}
	public static function staff_list_array($param='name'){
		$center_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT staff_id,full_name,staff_no from staff WHERE 1 ORDER BY full_name ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$center_chart[$row['staff_id']] = $row['full_name'];
				else{
					$center_chart[$row['staff_id']] = $row['staff_no'];
				}
			}
		}
		return $center_chart;
	}
	public static function center_list_array($param='name'){
		$center_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT center_id,center_no, center_name FROM  center WHERE 1 ORDER BY center_name ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$center_chart[$row['center_id']] = $row['center_name'];
				else{
					$center_chart[$row['center_id']] = $row['center_no'];
				}
			}
		}
		return $center_chart;
	}
	public static function branch_list_array($param='name'){
		$branch_chart = array();
		$CI = &get_instance();
		$query=$CI->db->query("SELECT branch_id,branch_no, branch_name FROM  branch WHERE 1 ORDER BY branch_name ASC");
		$rows=$query->result_array();
		if(count($rows)>0){
			foreach($rows as $row){
				if($param=='name')
					$branch_chart[$row['branch_id']] = $row['branch_name'];
				else{
					$branch_chart[$row['branch_id']] = $row['branch_no'];
				}
			}
		}
		return $branch_chart;
	}
	
	public static function get_income_head($sel=''){
		$CI = &get_instance();
		$con="";
        $query = $CI->db->query("select * from income_head where  status=1 order by title asc");
		$str="<option value=''>[All Head]</option>";
        foreach ($query->result_array() as $u) {
			$name=$u['title'];
            if ($sel == $u['id']) {
                $str.="<option value='" . $u['id'] . "' selected>" . $name . "</option>";
            } else {
                $str.="<option value='" . $u['id'] . "' >" . $name . "</option>";
            }
        }
        return $str;
	}
	public static function get_expense_head($sel=''){
		$CI = &get_instance();
		$con="";
        $query = $CI->db->query("select * from expense_head where  status=1 order by title asc");
		$str="<option value=''>[All Head]</option>";
        foreach ($query->result_array() as $u) {
			$name=$u['title'];
            if ($sel == $u['id']) {
                $str.="<option value='" . $u['id'] . "' selected>" . $name . "</option>";
            } else {
                $str.="<option value='" . $u['id'] . "' >" . $name . "</option>";
            }
        }
        return $str;
	}
	public static function add_business_days($startdate,$businessdays,$holidays,$dateformat){  
	   $i=1;  
	   $dayx = strtotime($startdate);  
	  while($i < $businessdays){  
		 $day = date('N',$dayx);  
		 $date = date('Y-m-d',$dayx);  
		 if($day < 6 && !in_array($date,$holidays))$i++;  
		 $dayx = strtotime($date.' +1 day');  
	  }  
	  return date($dateformat,$dayx);
	}
	public static function get_savings_account_settings_data(){
		$data = null;
        $rows = sql::rows('savings_account_settings');
        if (count($rows) > 0) {
            foreach ($rows as $row) {
                $data['savings_account_ineterest_rate'.$row['year']] = $row['interest_rate'];
            }
        }
        return $data;
	}
	
	public static function is_saving_transaction($mid,$account_id){
		
        return sql::count('saving_account_transaction',"member_id='{$mid}' and account_id='{$account_id}'");
	}
	public static function is_dps_transaction($mid,$account_id){
		
        return sql::count('dps_account_transaction',"member_id='{$mid}' and account_id='{$account_id}'");
	}
	public static function get_opening_balance($branch_id,$date){
		$CI = &get_instance();
		$cash_in_query=$CI->db->query("select sum(loan_amount_daily) as daily_loan,sum(loan_amount_weekly) as weekly_loan,sum(loan_amount_monthly) as monthly_loan,sum(saving_amount_daily) as daily_saving,sum(saving_amount_weekly) as weekly_saving,sum(saving_amount_month) as monthly_saving,sum(dps_amount) as dps_amount,sum(insurance_amount) as insurance_amount,sum(online_charge_amount) as online_charge_amount, sum(share_amount) as share_amount from daily_cash_by_branch where branch_id='{$branch_id}' and date<'$date'");
		$cash_in=$cash_in_query->row_array();
		$sql_bank_withdraw_query= $CI->db->query("select sum(bank_amount) as amount from daily_bank_withdraw_by_branch where branch_id='{$branch_id}' and date<'$date'");
		$bank_withdraw=$sql_bank_withdraw_query->row_array();
		
		$sql_company_credit_query= $CI->db->query("select sum(amount) as amount from company_account_transaction where branch_id='{$branch_id}' and date<'$date' and transaction_type=1");
		$company_credit=$sql_company_credit_query->row_array();
		
		$sql_other_income_query= $CI->db->query("select sum(other_income) as amount from  daily_income_by_branch where branch_id='{$branch_id}' and date<'$date'");
		
		
		
		$other_income_row=$sql_other_income_query->row_array();
		$cash_in_total=$cash_in['share_amount']+$cash_in['daily_loan']+$cash_in['weekly_loan']+$cash_in['monthly_loan']+$cash_in['daily_saving']+$cash_in['weekly_saving']+$cash_in['monthly_saving']+$cash_in['dps_amount']+$cash_in['insurance_amount']+$bank_withdraw['amount']+$other_income_row['amount']+$company_credit['amount']+$cash_in['online_charge_amount'];
		
		$cash_out_query=$CI->db->query("select sum(loan_amount_daily) as daily_loan,sum(loan_amount_weekly) as weekly_loan,sum(loan_amount_monthly) as monthly_loan,sum(saving_withdraw_daily) as daily_saving,sum(saving_withdraw_weekly) as weekly_saving,sum(saving_withdraw_month) as monthly_saving,sum(dps_withdraw) as dps_amount,sum(share_withdraw) as share_withdraw from daily_expense_by_branch where branch_id='{$branch_id}' and date<'$date'");
		$cash_out=$cash_out_query->row_array();
		
		$sql_bank_deposit_query= $CI->db->query("select sum(bank_amount) as amount from daily_bank_deposit_by_branch where branch_id='{$branch_id}' and date<'$date'");
		$bank_deposit_row=$sql_bank_deposit_query->row_array();
		$sql_other_expense_query= $CI->db->query("select sum(other_expense) as amount from  daily_other_expense_by_branch where  branch_id='{$branch_id}' and date<'$date'");
		$other_expense_row=$sql_other_expense_query->row_array();
		
		$sql_death_claim_query= $CI->db->query("select sum(claim_amount) as amount from  daily_death_claim_branch where  branch_id='{$branch_id}' and date<'$date'");
		$other_expense_row=$sql_other_expense_query->row_array();
		
		$death_claim_row=$sql_death_claim_query->row_array();
		
		
		$sql_company_debit_query= $CI->db->query("select sum(amount) as amount from company_account_transaction where branch_id='{$branch_id}' and date<'$date' and transaction_type=2");
		$company_debit=$sql_company_debit_query->row_array();
		
		$cash_out_total=$cash_out['daily_loan']+$cash_out['weekly_loan']+$cash_out['monthly_loan']+$cash_out['daily_saving']+$cash_out['weekly_saving']+$cash_out['monthly_saving']+$cash_out['dps_amount']+$bank_deposit_row['amount']+$other_expense_row['amount']+$company_debit['amount']+$cash_out['share_withdraw']+$death_claim_row['amount'];
		return ($cash_in_total-$cash_out_total);
		
	}
	public static function add_days($orgDate,$mon){
		$cd = strtotime($orgDate);
		//$retDAY = date('Y-m-d', mktime(0,0,0,date('m',$cd)+$mon,date('d',$cd),date('Y',$cd)));
		$retDAY = date('Y-m-d', mktime(0,0,0,date('m',$cd),date('d',$cd)+$mon,date('Y',$cd)));
		return $retDAY;
	}
	public static function convert_number($number) 
{ 
    $my_number = $number;
    if (($number < 0) || ($number > 999999999)) 
    { 
    throw new Exception("Number is out of range");
    } 
    $Kt = floor($number / 10000000); /* Koti */
    $number -= $Kt * 10000000;
    $Gn = floor($number / 100000);  /* lakh  */ 
    $number -= $Gn * 100000; 
    $kn = floor($number / 1000);     /* Thousands (kilo) */ 
    $number -= $kn * 1000; 
    $Hn = floor($number / 100);      /* Hundreds (hecto) */ 
    $number -= $Hn * 100; 
    $Dn = floor($number / 10);       /* Tens (deca) */ 
    $n = $number % 10;               /* Ones */ 
    $res = ""; 
    if ($Kt) 
    { 
        $res .= common::convert_number($Kt) . " Core "; 
    } 
    if ($Gn) 
    { 
        $res .= common::convert_number($Gn) . " Lac"; 
    } 
    if ($kn) 
    { 
        $res .= (empty($res) ? "" : " ") . 
            common::convert_number($kn) . " Thousand"; 
    } 
    if ($Hn) 
    { 
        $res .= (empty($res) ? "" : " ") . 
            common::convert_number($Hn) . " Hundred"; 
    } 
    $ones = array("", "One", "Two", "Three", "Four", "Five", "Six", 
        "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", 
        "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", 
        "Nineteen"); 
    $tens = array("", "", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", 
        "Seventy", "Eighty", "Ninety"); 
    if ($Dn || $n) 
    { 
        if (!empty($res)) 
        { 
            $res .= "  "; 
        } 
        if ($Dn < 2) 
        { 
            $res .= $ones[$Dn * 10 + $n]; 
        } 
        else 
        { 
            $res .= $tens[$Dn]; 
            if ($n) 
            { 
                $res .= " " . $ones[$n]; 
            } 
        } 
    } 
    if (empty($res)) 
    { 
        $res = "zero"; 
    } 
    return $res; 
} 
public static function get_member_saving_account_opening_balance($account_id,$date){
	$CI = &get_instance();
	$account=sql::row("saving_account","account_id='{$account_id}'");
	$credit_row=sql::row("saving_account_transaction"," account_id='{$account_id}' and transaction_type<>2 and date<'{$date}'","sum(amount) as credit");
	$debit_row=sql::row("saving_account_transaction"," account_id='{$account_id}' and transaction_type=2 and date<'{$date}'","sum(amount) as debit");
	$balance=$credit_row['credit']+$account['opening_balance']-$debit_row['debit'];
	return $balance;
	
}
public static function get_member_dps_account_opening_balance($account_id,$date){
	$CI = &get_instance();
	$account=sql::row("dps_account","account_id='{$account_id}'");
	$credit_row=sql::row("dps_account_transaction"," account_id='{$account_id}' and transaction_type=1 and date<'{$date}'","sum(amount) as credit");
	$debit_row=sql::row("dps_account_transaction"," account_id='{$account_id}' and transaction_type=2 and date<'{$date}'","sum(amount) as debit");
	$balance=$credit_row['credit']+$account['opening_balance']-$debit_row['debit'];
	return $balance;
	
}
public static function get_member_loan_account_opening_balance($loan_id,$date){
	$CI = &get_instance();
	$account=sql::row("loan","loan_id='{$loan_id}'");
	$debit=sql::row("loan_transaction"," loan_id='{$loan_id}'  and date<'{$date}'","sum(amount) as debit");
	$balance=$account['opening_balance']-$debit['debit'];
	return $balance;
	
}

public static function is_loan_transaction($loan_id){
return sql::count("loan_transaction","loan_id='{$loan_id}'");	
	
}
public static function get_account_type($type){
	//echo $type;
$array=array(1=>"Daily",2=>"Weekly",3=>"Monthly");
	return $array[$type];
}
public static function get_weeks(){
	$HowManyWeeks = date( 'W', strtotime( '2021-07-31' ) ) - date( 'W', strtotime( '2021-07-01' ) );
	echo $HowManyWeeks;
}
public static function datediff( $interval, $datefrom, $dateto, $using_timestamps = false ) {
	if( $datefrom != "" and $dateto != "" ) {
		if( !$using_timestamps ) {
			$datefrom = strtotime( $datefrom, 0 );
			$dateto = strtotime( $dateto, 0 );
		}
		$difference = $dateto - $datefrom; // Difference in seconds
		switch( $interval ) {
			case 'yyyy': // Number of full years
			
				$years_difference = floor( $difference / 31536000 ); 
				if( mktime( date( "H", $datefrom ), date( "i", $datefrom ), date( "s", $datefrom ), date( "n", $datefrom ), date( "j", $datefrom ), date( "Y", $datefrom ) + $years_difference ) > $dateto ) {
					$years_difference--;
				}
				if( mktime( date( "H", $dateto ), date( "i", $dateto ), date( "s", $dateto ), date( "n", $dateto ), date( "j", $dateto ), date( "Y", $dateto ) - ( $years_difference + 1 ) ) > $datefrom ) {
					$years_difference++;
				}
				$datediff = $years_difference;
				break;
			case "q": // Number of full quarters
				$quarters_difference = floor( $difference / 8035200 );
				while( mktime( date( "H", $datefrom ), date( "i", $datefrom ), date( "s", $datefrom ), date( "n", $datefrom ) + ( $quarters_difference * 3 ), date( "j", $dateto ), date( "Y", $datefrom ) ) < $dateto ) {
					$months_difference++;
				}
				$quarters_difference--;
				$datediff = $quarters_difference;
				break;
			case "m": // Number of full months
				$months_difference = floor( $difference / 2678400 );
				while( mktime( date( "H", $datefrom ), date( "i", $datefrom ), date( "s", $datefrom ), date( "n", $datefrom ) + ( $months_difference ), date( "j", $dateto ), date( "Y", $datefrom ) ) < $dateto ) {
					$months_difference++;
				}
				//$months_difference--;
				$datediff = $months_difference;
				break;
			case 'y': // Difference between day numbers
				$datediff = date( "z", $dateto ) - date( "z", $datefrom );
				break;
			case "d": // Number of full days
				$datediff = ( floor( $difference / 86400 ) + 1 );
				break;
			case "w": // Number of full weekdays
				$days_difference = floor( $difference / 86400 );
				$weeks_difference = floor( $days_difference / 7 ); // Complete weeks
				$first_day = date( "w", $datefrom );
				$days_remainder = floor( $days_difference % 7 );
				$odd_days = $first_day + $days_remainder; // Do we have a Saturday or Sunday in the remainder?
				if( $odd_days > 7 ) $days_remainder--;	// Sunday
				if( $odd_days > 6 ) $days_remainder--;	// Saturday
				$datediff = ( $weeks_difference * 5 ) + $days_remainder;
				break;
			case "ww": // Number of full weeks
				$datediff = floor( $difference / 604800 );
				break;
			case "fw": // Number of full weeks with fraction weeks adding up
				$datediff = ceil( $difference / 604800 );
				//$datediff = floor( $difference / 604800 );
				break;
			case "h": // Number of full hours
				$datediff = floor( $difference / 3600 );
				break;
			case "n": // Number of full minutes
				$datediff = floor( $difference / 60 );
				break;
			default: // Number of full seconds (default)
				$datediff = $difference;
				break;
		}
		return $datediff;
	}
}
public static function weekOfMonth($date) {
    //Get the first day of the month.
    $firstOfMonth = strtotime(date("Y-m-01", $date));
    //Apply above formula.
    return common::weekOfYear($date) - common::weekOfYear($firstOfMonth) + 1;
}
public static function weekOfYear($date) {
    $weekOfYear = intval(date("W", $date));
    if (date('n', $date) == "1" && $weekOfYear > 51) {
        // It's the last week of the previos year.
        $weekOfYear = 0;    
    }
    return $weekOfYear;
}

public static function calculate_working_days($start,$end){
	$start = new DateTime($start);
	$end = new DateTime($end);
	// otherwise the  end date is excluded (bug?)
	$end->modify('+1 day');

	$interval = $end->diff($start);

	// total days
	$days = $interval->days;

	// create an iterateable period of date (P1D equates to 1 day)
	$period = new DatePeriod($start, new DateInterval('P1D'), $end);

	// best stored as array, so you can add more than one
	$holidays = array('2012-09-07');

	foreach($period as $dt) {
		$curr = $dt->format('D');

		// substract if Saturday or Sunday
		if ($curr == 'Fri') {
			$days--;
		}

		// (optional) for the updated question
		elseif (in_array($dt->format('Y-m-d'), $holidays)) {
			$days--;
		}
	}
	return $days;
}
public static function getMac(){
	ob_start();
		 system('ipconfig/all');
		$mycom=ob_get_contents(); 
		ob_clean(); 
		$findme = "Physical";
		$pmac = strpos($mycom, $findme); 
		$mac=substr($mycom,($pmac+36),17);
	return $mac;
}
public static function checkMac(){
	return true;
	$mac=json_decode(MAC);
	$device_mac=common::getMac();
	if(!in_array($device_mac,$mac)){
		return false;
	}
	else{
		return true;
	}
}
public static function is_super(){
		 $CI = & get_instance();
		 if($CI->session->userdata("is_super")==1)
			 return true;
		 else{
			 return false;
		 }
	}
public static function get_user_center(){
	$CI=&get_instance();
	$user_center=$CI->session->userdata('center_id');
	if($user_center!=""){
		$rows=sql::rows("center","center_id in({$user_center})","center_no");
		$center=array_column($rows,"center_no");
		return implode(",",$center);
	}
}
public static function module_permission($module){
	$CI=&get_instance();
	$user_id=$CI->session->userdata('user_id');
	$role_id=$CI->session->userdata('role_id');
	$is_super=$CI->session->userdata('is_super');
	if($is_super)
		return true;
	else 
		return sql::count("user_role_view","role_id='{$role_id}' and user_id='{$user_id}' and module_name='{$module}'");
}
public static function page_permission($module,$page_name){
	$CI=&get_instance();
	$user_id=$CI->session->userdata('user_id');
	$role_id=$CI->session->userdata('role_id');
	$is_super=$CI->session->userdata('is_super');
	if($is_super)
		return true;
	else 
		return sql::count("user_role_view","role_id='{$role_id}' and user_id='{$user_id}' and module_name='{$module}' and permission_name='{$page_name}'");
	
}
public static function getNoMonth($date){
 // Declare and define two dates
 $date1 = $date;
$date2 = '2024-12-31';

$ts1 = strtotime($date1);
$ts2 = strtotime($date2);

$year1 = date('Y', $ts1);
$year2 = date('Y', $ts2);

$month1 = date('m', $ts1);
$month2 = date('m', $ts2);
return $diff = (($year2 - $year1) * 12) + ($month2 - $month1)+1;
//$diff = (($year2 - $year1) * 12) + ($month2 - $month1


  $date1 = strtotime($date);
  $date2 = strtotime("2024-12-31");

  // Formulate the Difference between two dates
  $diff = abs($date2 - $date1);
  //echo $date2;exit;
  // To get the year divide the resultant date into
  // total seconds in a year (365*60*60*24)
  $years = floor($diff / (365*60*60*24));
 
  // To get the month, subtract it with years and
  // divide the resultant date into
  // total seconds in a month (30*60*60*24)
  $months = floor(($diff - $years * 365*60*60*24)
                                 / (30*60*60*24));
 
  // To get the day, subtract it with years and
  // months and divide the resultant date into
  // total seconds in a days (60*60*24)
  $days = floor(($diff - $years * 365*60*60*24 -
               $months*30*60*60*24)/ (60*60*24));
 
  // To get the hour, subtract it with years,
  // months & seconds and divide the resultant
  // date into total seconds in a hours (60*60)
  $hours = floor(($diff - $years * 365*60*60*24
         - $months*30*60*60*24 - $days*60*60*24)
                                     / (60*60));
 
  // To get the minutes, subtract it with years,
  // months, seconds and hours and divide the
  // resultant date into total seconds i.e. 60
  $minutes = floor(($diff - $years * 365*60*60*24
           - $months*30*60*60*24 - $days*60*60*24
                            - $hours*60*60)/ 60);
 
  // To get the minutes, subtract it with years,
  // months, seconds, hours and minutes
  $seconds = floor(($diff - $years * 365*60*60*24
           - $months*30*60*60*24 - $days*60*60*24
                  - $hours*60*60 - $minutes*60));
 
  // Print the result
  return $months;
 // printf("%d years, %d months, %d days, %d hours, "
      // . "%d minutes, %d seconds", $years, $months,
         //      $days, $hours, $minutes, $seconds);
}
public static function count_pending_req($status=0){
		$CI=&get_instance();
		$con=" where 1 and loan_requision.status='{$status}'";
		if ($_REQUEST['branch_id']) 
		{
			 $con.=" and loan_requision.branch_id='{$_REQUEST['branch_id']}'";
		}
		else{
			if(!common::is_super()&&$CI->session->userdata("branch_id")!=""){
				$con.=" and loan_requision.branch_id in('".$CI->session->userdata("branch_id")."')";
			}
		}
		
		if ($_REQUEST['center_id']) {
			$con.=" and loan_requision.center_id in ({$_REQUEST['center_id']})";
		}
		else{
			if(!common::is_super()&&$CI->session->userdata("center_id")!=""){
				$con.=" and loan_requision.center_id in(".$CI->session->userdata("center_id").")";
			}
		}
		$query = $CI->db->query("select count(req_id) as total  from loan_requision 
		 $con ");
		// echo $this->db->last_query();exit;
       $row=$query->row_array();
	   return $row['total'];
	}
	public static function  count_time_length($date_from,$date_to)
	{
		$now = $date_to;
		$date_from = explode('-', $date_from);
		$now = explode('-', $now);
		$mnt = array(1 => 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
		if (($now[2]%400 == 0) or ($now[2]%4==0 and $now[2]%100!=0)) $mnt[2]=29;
		if($now[0] < $date_from[0]){
			$now[0] += $mnt[$now[1]-1];
			$now[1]--;
		}
		if($now[1] < $date_from[1]){
			$now[1] += 12;
			$now[2]--;
		}
		if($now[2] < $date_from[2]) return false;
		return  array('year' => $now[2] - $date_from[2], 'mnt' => $now[1] - $date_from[1], 'day' => $now[0] - $date_from[0]);
	}
	public static function convert_to_mysql_date( $date_field ) {
	//echo $date_field;
	if( $date_field != '' ) {
		$dates = explode( "-", $date_field );
		//print_r($dates);
		return $dates[2] . "-" . $dates[1] . "-" . $dates[0];
	}
	else return $date_field;
}
public function get_account_status($val){
	$status=array('1'=>'Open','0'=>'Close');
	return $status[$val];
}
public static function get_account_no($no){
		return str_pad($no,8,"0",STR_PAD_LEFT);
	}
	public static function get_loan_previous_data($zone_id,$area_id,$branch_id,$date){
		if ($branch_id) 
	{
		 $branch ="and balance.branch_id='{$branch_id}'";
	}
	else{
		if(!common::is_super()&&$this->session->userdata("branch_id")!=""){
			$branch=" and balance.branch_id in('".$this->session->userdata("branch_id")."')";
		}
	}
	if ($zone_id) 
	{
		 $branch ="and balance.zone_id='{$zone_id}'";
	}
	if ($area_id) 
	{
		 $branch ="and balance.area_id='{$area_id}'";
	}
	if($date)
		$date= " and balance.date <'{$date}'";
	$CI = &get_instance();
		$query=$CI->db->query("select sum(loan.balance) as balance,sum(loan.loan_amount) as loan_amount,count(loan.member_id) as beneficiary,sum(loan_transaction.amount) as transaction_amount from balance left join loan on loan.loan_id=balance.loan_id left join loan_transaction on loan_transaction.transaction_id=balance.loan_transaction_id where 1 and (balance.loan_id<>'' or balance.loan_id <>0 or balance.loan_transaction_id<>'' or balance.loan_transaction_id <>0)  $date $branch $area_id $zone_id");
		return $query->row_array();
	}
	public static function getPosStartAndCountPerPage() {
        global $global_config;
        
        if (isset ( $_GET ["posStart"] ) && $_GET ["posStart"] != '') {
                $pos_start = $_GET ['posStart'];
        } else {
                $pos_start = 0;
        }
        
        if (isset ( $_GET ["count"] ) && $_GET ["count"] != '') {
                $perpage_cnt = $_GET ['count'];
        } else {
                $perpage_cnt = $global_config ['perpage_cnt'];
        }
        
        return array ($pos_start, $perpage_cnt );
}
public static function get_bank_list($sel='',$center_id='') {
        $CI = &get_instance();
		$con="";
		$str="<option value=''>[Bank]</option>";
		$bank=sql::rows("lib_bank");	
		if(count($bank)>0){
			foreach($bank as $b){
				//$str.='<optgroup label="'.$b['bank_name'].'">';
				//$query = $CI->db->query("select * from lib_bank_account where 1 and account_id='{$b['id']}' $con order by account_no asc ");
			
					if ($sel == $b['id']) {
						$str.="<option value='" . $b['id'] . "' selected>" . $b['bank_name'] . "-->".$b['branch_name']."</option>";
					} else {
						$str.="<option value='" . $b['id'] . "' >" . $b['bank_name'] . "-->".$b['branch_name']."</option>";
					}
			
				
			}
		}
		return $str;
	}
	public static function get_cash_register_loan_opening_balance($date,$branch){
		 $CI = &get_instance();
		$query = $CI->db->query("select loan_cash_register.date,sum(loan_cash_register.balance) as balance,sum(loan_cash_register.loan_amount_daily) as loan_amount_daily,sum(loan_cash_register.loan_amount_weekly) as loan_amount_weekly,sum(loan_cash_register.loan_amount_monthly) as loan_amount_monthly,
	sum(loan_cash_register.daily_service_charge) as daily_service_charge,
	sum(loan_cash_register.weekly_service_charge) as weekly_service_charge,
	sum(loan_cash_register.monthly_service_charge) as monthly_service_charge,
	sum(loan_cash_register.no_loan_member) as beneficiary,sum(loan_cash_register.loan_collection_daily) as transaction_amount_daily,sum(loan_cash_register.loan_collection_weekly) as transaction_amount_weekly,sum(loan_cash_register.loan_collection_monthly) as transaction_amount_monthly,sum(loan_cash_register.no_collection_member)  as collection_member,sum(loan_close) as loan_close,loan_cash_register.area_id,loan_cash_register.zone_id,loan_cash_register.branch_id from loan_cash_register where 1 and loan_cash_register.date<'{$date}' and loan_cash_register.branch_id='{$branch}'");
	$result=$query->row_array();
	return $result;
	//echo $CI->db->last_query();exit;
	/*$grand_total_collection=$result['transaction_amount_daily']+$result['transaction_amount_weekly']+$result['transaction_amount_monthly'];
	$grand_total_loan=$result['loan_amount_monthly']+$result['loan_amount_weekly']+$result['loan_amount_daily']+$result['daily_service_charge']+$result['weekly_service_charge']+$result['monthly_service_charge'];
	$opening_balance=$grand_total_loan-$grand_total_collection;
	return $grand_total_loan;*/
	}
	public static function get_cash_register_saving_opening_balance($date,$branch){
		
		 $CI = &get_instance();
		 $query=$CI->db->query("select sum(saving_cash_register.credit_amount_daily) as credit_amount_daily,sum(saving_cash_register.credit_amount_weekly) as credit_amount_weekly,sum(saving_cash_register.credit_amount_monthly) as credit_amount_monthly,sum(saving_cash_register.debit_amount_daily) as debit_amount_daily,sum(saving_cash_register.debit_amount_weekly) as debit_amount_weekly,sum(saving_cash_register.debit_amount_monthly) as debit_amount_monthly,sum(saving_cash_register.saving_interest_daily)  as saving_interest_daily,sum(saving_cash_register.saving_interest_weekly)  as saving_interest_weekly,sum(saving_cash_register.saving_interest_monthly)  as saving_interest_monthly from saving_cash_register where 1 and saving_cash_register.date<'{$date}' and saving_cash_register.branch_id='{$branch}'");
		/*$query = $CI->db->query("select sum(loan_cash_register.loan_amount_daily) as loan_amount_daily,sum(loan_cash_register.loan_amount_weekly) as loan_amount_weekly,sum(loan_cash_register.loan_amount_monthly) as loan_amount_monthly,
	sum(loan_cash_register.daily_service_charge) as daily_service_charge,
	sum(loan_cash_register.weekly_service_charge) as weekly_service_charge,
	sum(loan_cash_register.monthly_service_charge) as monthly_service_charge,
	sum(loan_cash_register.loan_collection_daily) as transaction_amount_daily,sum(loan_cash_register.loan_collection_weekly) as transaction_amount_weekly,sum(loan_cash_register.loan_collection_monthly) as transaction_amount_monthly from loan_cash_register where 1 and loan_cash_register.date<'{$date}' and loan_cash_register.branch_id='{$branch}'");*/
	$result=$query->row_array();
	$grand_total_credit=$result['credit_amount_daily']+$result['credit_amount_weekly']+$result['credit_amount_monthly'];
	$grand_total_debit=$result['credit_amount_daily']+$result['debit_amount_weekly']+$result['debit_amount_monthly'];
	$grand_total_interest=$result['saving_interest_daily']+$result['saving_interest_weekly']+$result['saving_interest_monthly'];
	//$grand_total_loan=$result['loan_amount_monthly']+$result['loan_amount_weekly']+$result['loan_amount_daily']+$result['daily_service_charge']+$result['weekly_service_charge']+$result['monthly_service_charge'];
	$balance=$opening_balance+$grand_total_credit-$grand_total_debit-$grand_total_interest;
	//$opening_balance=$opening_balance+$grand_total_collection-$grand_total_loan;
	return $balance;
	}
	public static function send_sms($url)
	{
		$ch = curl_init();
		$timeout = 5;

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);

		$data = curl_exec($ch);

		curl_close($ch);

		return $data;
		}
		public static function getExecuteQuery(){
			 $CI = &get_instance();
			// SET GLOBAL sql_mode=''
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'STRICT_TRANS_TABLES', ''));");
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'NO_ZERO_IN_DATE', ''));");
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'NO_ZERO_DATE', ''));");
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ERROR_FOR_DIVISION_BY_ZERO', ''));");
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'NO_AUTO_CREATE_USER', ''));");
			$CI->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'NO_AUTO_CREATE_USER', ''));");
		}
}
?>