<?php

class common {

    public static function redirect() {
        $CI = & get_instance();
        $uri = $CI->session->userdata('cur_uri');
        if ($uri == '')
            $uri = 'home';
        redirect($uri);
    }

    public static function track_uri() {
        $CI = & get_instance();
        $uri = $CI->uri->uri_string();
        $CI->session->set_userdata('cur_uri', $uri);
    }

    public static function is_logged_in() {
        $CI = & get_instance();
        if ($CI->session->userdata('logged_in') || $CI->session->userdata('agent_logged_in')) {
            return true;
        } else {
            return false;
        }
    }

    public static function is_user_logged() {
        $CI = & get_instance();
        if ($CI->session->userdata('logged_in')) {
            return true;
        } else {
            return false;
        }
    }

    public static function is_logged() {

        $CI = & get_instance();
        if (!$CI->session->userdata('logged_in') && !$CI->session->userdata('agent_logged_in')) {
            redirect('login');
        }
    }

    public static function is_agent_logged() {

        $CI = & get_instance();
        $CI = & get_instance();
        if ($CI->session->userdata('agent_logged_in')) {
            return true;
        } else {
            return false;
        }
    }

    public static function get_settings_data() {
        $data = null;
        $rows = sql::rows('settings');
        if (count($rows) > 0) {
            foreach ($rows as $row) {
                $data[$row['key_flag']] = $row['key_value'];
            }
        }
        return $data;
    }

    public static function sending_mail($from_name, $from_email, $to_email, $subject, $msg_content) {
        $CI = & get_instance();
        $CI->load->library('email');
        $config['protocol'] = 'sendmail';
        $config['mailpath'] = '/usr/sbin/sendmail';
        $config['charset'] = 'utf-8';
        $config['wordwrap'] = TRUE;
        $config['mailtype'] = 'html';

        $CI->email->initialize($config);

        $CI->email->from('info@togetherf.com', $from_name);
        $CI->email->to($to_email);
        $CI->email->subject($subject);
        $CI->email->message($msg_content);
        $CI->email->send();
    }

    public static function get_country($sel='') {
        $country_list = array("Afghanistan", "Albania", "Algeria", "Andorra", "Angola", "Antigua and Barbuda", "Argentina", "Armenia", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bhutan", "Bolivia", "Bosnia and Herzegovina", "Botswana", "Brazil", "Brunei", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Central African Republic", "Chad", "Chile", "China", "Colombi", "Comoros", "Congo (Brazzaville)", "Congo", "Costa Rica", "Cote d'Ivoire", "Croatia", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor (Timor Timur)", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Fiji", "Finland", "France", "Gabon", "Gambia, The", "Georgia", "Germany", "Ghana", "Greece", "Grenada", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Honduras", "Hungary", "Iceland", "India", "Indonesia", "Iran", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, North", "Korea, South", "Kuwait", "Kyrgyzstan", "Laos", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein", "Lithuania", "Luxembourg", "Macedonia", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Mauritania", "Mauritius", "Mexico", "Micronesia", "Moldova", "Monaco", "Mongolia", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepa", "Netherlands", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Poland", "Portugal", "Qatar", "Romania", "Russia", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Serbia and Montenegro", "Seychelles", "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "Spain", "Sri Lanka", "Sudan", "Suriname", "Swaziland", "Sweden", "Switzerland", "Syria", "Taiwan", "Tajikistan", "Tanzania", "Thailand", "Togo", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "Uruguay", "Uzbekistan", "Vanuatu", "Vatican City", "Venezuela", "Vietnam", "Yemen", "Zambia", "Zimbabwe");
        $opt.="<option value='' >--Select Country--</option>";
        for ($i = 0; $i < count($country_list); $i++) {
            if ($country_list[$i] == $sel) {
                $opt.="<option value='$country_list[$i]' selected='selected'>$country_list[$i]</option>";
            } else {
                if ($country_list[$i] == 'Bangladesh')
                    $opt.="<option value='$country_list[$i]' selected>$country_list[$i]</option>";
                else
                    $opt.="<option value='$country_list[$i]'>$country_list[$i]</option>";
            }
        }
        return $opt;
    }

    public static function is_member_transaction_password() {
        $CI = & get_instance();
        $member_id = $CI->session->userdata('member_id');
        $query = $CI->db->query("select transaction_password from mlm_members where member_id='$member_id'");
        $row = $query->row_array();
        if ($row['transaction_password'])
            return true;
        else
            return false;
    }

    public static function check_user() {
        $CI = & get_instance();
        if ($CI->session->userdata('member_id') == '') {
            redirect("members/register");
        }
    }

    public static function get_sponsor_id($sponsor_id='', $name='') {
        $sponsor_id = trim($sponsor_id);
        $name = trim($name);
        $CI = & get_instance();
        $sql = $CI->db->query("select member_id from mlm_members where member_name='{$sponsor_id}'");
        $row = $sql->row_array();
        if ($row['member_id'] != '') {
            return $row['member_id'];
        } else {
            return 0;
        }
    }

    public static function get_feature_news() {
        $CI = & get_instance();
        $query = $CI->db->query("select * from mlm_news where news_delete=0 and news_status=1 order by news_posted_date desc limit 0,10 ");
        return $query->result_array();
    }

    public static function member_row_field($member_id, $field) {
        $CI = &get_instance();
        $query = $CI->db->query("select * from mlm_members where mmeber_id=$member_id");
        $row = $query->row_array();
        return $row[$field];
    }

    public static function check_valid_user($con='', $page='') {
        $CI = &get_instance();
        $member_id = $CI->session->userdata('member_id');
        $row = sql::row("mlm_members", "member_id='$member_id'", 'transaction_password');
        if ($row['transaction_password'] == '') {
            redirect("my_account/generate_transaction_password");
        }
        if ($CI->session->userdata('transaction_password') == '') {
            redirect('?c=account&m=transaction_password&con=' . $con . '&action_page=' . $page);
        }
    }
    public static function get_member_sponsor_list($mid=0, $data=array()) {
        $CI = &get_instance();
        $member_list = $data;
        if ($mid == 0) {
            return $member_list;
        } else {
            $mem = sql::row("mlm_members", "member_id=$mid");
            $member_list[] = $mem['position_sponsor_id'];
            if ($mem['position_sponsor_id'] != 0) {
                $member_list = common::get_member_sponsor_list($mem['position_sponsor_id'], $member_list);
            }
        }
        return $member_list;
    }

    public static function is_left_member($mid='') {
        $CI = &get_instance();
        $query = $CI->db->query("select count(left_member_id) as total from mlm_members where left_member_id='$mid'");
        $row = $query->row_array();
        if ($row['total'] > 0)
            return true;
        return false;
    }

    public static function is_right_member($mid='') {
        $CI = &get_instance();
        $query = $CI->db->query("select count(right_member_id) as total from mlm_members where right_member_id='$mid'");
        $row = $query->row_array();
        if ($row['total'] > 0)
            return true;
        return false;
    }

    public static function total_member_invest_amount($member_id) {
        $CI = &get_instance();
        $query = $CI->db->query("select sum(invest_amount) as invest from mlm_member_invest where member_id=$member_id");
        $row = $query->row_array();
        if ($row['invest'] == '')
            return 0;
        else
            return $row['invest'];
    }

    public static function valid_invest_member($mid='', $member_type='') {
        $site = common::get_settings_data();
        $total_invest = common::total_member_invest_amount($mid);
        if ($member_type == 1) {
            $invest_amount_from = $site['sun_min_invest_amount'];
            $invest_amount_to = $site['sun_max_invest_amount'];
        } else {
            $invest_amount_from = $site['moon_min_invest_amount'];
            $invest_amount_to = $site['moon_max_invest_amount'];
        }
        if ($total_invest <= $invest_amount_to) {
            return true;
        } else {
            return false;
        }
    }

    public static function member_balance($member_id='', $type='') {
        $income = common::get_member_income($member_id);
        $incomming_amount = common::get_member_incomming_amount($member_id, $type);
        $outgoing_amount = common::get_member_outgoing_amount($member_id);
        $withdraw_amount = common::get_member_withdraw_amount($member_id);
        $repeat_amount = common::get_member_repeat_amount($member_id);
        $balance = $income + $incomming_amount + $repeat_amount - $outgoing_amount - $withdraw_amount - $invest_amount;
        return $balance;
    }

    public static function get_member_invest_amount($member_id='') {
        $CI = &get_instance();
        $query = $CI->db->query("select sum(invest_amount) as total_invest from  mlm_member_invest  where member_id=$member_id");
        $row = $query->row_array();
        return $row['total_invest'];
    }

    public static function get_member_income($member_id='') {
        $CI = &get_instance();
        $con = " ";
        if ($_REQUEST['date_from'] && $_REQUEST['date_to']) {
            $con.=" and income_date between '$_REQUEST[date_from]' and '$_REQUEST[date_to]'";
        }
        $query = $CI->db->query("select sum(income_amount) as total_income from mlm_member_income  where member_id=$member_id $con");
        $row = $query->row_array();
        return $row['total_income'];
    }

    public static function get_member_incomming_amount($member_id, $type='') {
        $CI = &get_instance();
        $con = "";
        $con = " and transfer_type=0";
        $query = $CI->db->query("select sum(transfer_amount) as total_incomming from mlm_money_transfer where transfer_to_member_id=$member_id $con");
        $row = $query->row_array();
        return $row['total_incomming'];
    }

    public static function get_member_outgoing_amount($member_id) {
        $CI = &get_instance();
        $query = $CI->db->query("select sum(transfer_amount) as total_outgoing from mlm_money_transfer where transfer_from_member_id=$member_id");
        $row = $query->row_array();
        if ($row['total_outgoing'] == '')
            return 0;
        else
            return $row['total_outgoing'];
    }

    public static function get_member_withdraw_amount($member_id) {
        $CI = &get_instance();
        $query = $CI->db->query("select sum(withdraw_amount) as withdraw_amount from mlm_money_withdraw where withdraw_member_id =$member_id and withdraw_type=0");
        $row = $query->row_array();
        if ($row['withdraw_amount'] == '')
            return 0;
        else
            return $row['withdraw_amount'];
    }

    public static function get_member_repeat_amount($member_id) {
        $CI = &get_instance();
        $query = $CI->db->query("select sum(paid_amount) as paid_amount  from mlm_invest_payment where member_id =$member_id ");
        $row = $query->row_array();
        if ($row['paid_amount'] == '')
            return 0;
        else
            return $row['paid_amount'];
    }

    public static function get_pending_withdraw_request($member_id='') {
        $CI = &get_instance();
        $query = $CI->db->query("select sum(withdraw_amount) as total_withdraw_amount,count(withdraw_id) as total_withdraw_request from mlm_money_withdraw where withdraw_status=0 and withdraw_member_id=$member_id");
        $row = $query->row_array();
        return $row;
    }

    public static function get_spot_commission($member_id) {
        return common::get_member_income($member_id);
    }

    public static function pr($arr=array()) {
        if (is_array($arr)) {
            echo '<pre>';
            print_r($arr);
            echo '<pre>';
        }
    }

    public static function security_question_select_box($sel='', $id='') {
        if ($id) {
            $con.=" and question_id=$id";
        }
        $rows = sql::rows("security_question", "question_status=1 $con");
        $str = "";
        foreach ($rows as $q) {
            if ($q['question_id'] == $sel) {
                $str.= "<option value='" . $q['question_id'] . "' selected>" . $q['question_title'] . "</option>";
            } else {
                $str.= "<option value='" . $q['question_id'] . "'>" . $q['question_title'] . "</option>";
            }
        }
        return $str;
    }
    public static function get_incoming_invest_amount($mid=''){
        $CI=&get_instance();
        $query=$CI->db->query("select sum(transfer_amount) as total_amount from mlm_money_transfer where transfer_to_member_id='$mid' and transfer_type=1");
        $row=$query->row_array();
        return $row['total_amount'];
    }
    public static function get_outgoing_invest_amount($mid=''){
        $CI=&get_instance();
        $query=$CI->db->query("select sum(invest_amount) as total_amount from mlm_member_invest where member_id='$mid'");
        $row=$query->row_array();
        return $row['total_amount'];
    }

    function get_invest_balanace($mid='') {
        $incoming_invest = common::get_incoming_invest_amount($mid);
        $outgoing_invest = common::get_outgoing_invest_amount($mid);
        $balance=$incoming_invest-$outgoing_invest;
        return $balance;
    }

}

?>