<?php

class users extends CI_Controller {

    private $dir = 'users';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_users');
        common::is_logged();
		if (!common::is_super()) {
            $this->session->set_flashdata("warning_msg", "You are not allowed access this page");
            common::redirect('home');
        }
		common::getExecuteQuery();
    }

    function index() {
		$id=$_REQUEST['id'];
		 if ($_POST['save']) {
				if($id){
					$this->mod_users->update_user($id);
					$this->session->set_flashdata('msg', 'User was Updated Successfully!!!');
					redirect('?c=users');
				}
					
					else{
				
					if ($this->mod_users->save_user()) {
						$this->session->set_flashdata('msg', 'User was Added Successfully!!!');
						redirect('?c=users');
					}
				}
			
		}
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_users->get_user_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('c=users&m=index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_users->get_user_list($limit = true, $start, $config['per_page']);
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		$data['users']=sql::row("users","user_id='{$id}'");
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Users";
        $data['page_title'] = 'Users';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	function role() {
		
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_users->get_user_role());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('c=users&m=index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_users->get_user_role($limit = true, $start, $config['per_page']);
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "User Role";
        $data['page_title'] = 'User Role';
        $data['page'] = 'user_role';
        $this->load->view('main', $data);
    }
 function add_role() {
	  
        if ($_POST['save']) {
			if ($this->form_validation->run('valid_role')) {
			if ($this->mod_users->save_role()) {
				$this->session->set_flashdata('success_msg', 'User role was Added Successfully!!!');
				redirect('?c=users&m=role');
			}
				
			}
        }
        $data['header_title'] = "Role Add";
        $data['action'] = site_url('users/add_role');
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Role Add";
        $data['page'] = 'new_role';
        $this->load->view('main', $data);
    }
	function add_user() {
        if ($_POST['save']) {
			if ($this->mod_users->save_user()) {
				$this->session->set_flashdata('success_msg', 'User role was Added Successfully!!!');
				redirect('?c=users&m=index');
			}
        }
        $data['header_title'] = "Add user";
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Users Add";
        $data['page'] = 'new_user';
        $this->load->view('main', $data);
    }
	function reset_password() {
        if ($_POST['save']) {
			
			if ($this->mod_users->save_password($_REQUEST['id'])) {
				$this->session->set_flashdata('success_msg', 'password  was reset  Successfully!!!');
				redirect('?c=users&m=index');
			}
			
        }
        $data['header_title'] = "Add user";
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Users Add";
        $data['page'] = 'reset_password';
        $this->load->view('main', $data);
    }
	function edit_role() {
		$id=$_REQUEST['id'];
        if ($_POST['save']) {
			 if ($this->form_validation->run('valid_role')) {
				if($this->mod_users->update_role($id)){
					$this->session->set_flashdata('success_msg', 'Role was Updated Successfully!!!');
					redirect('?c=users&m=role');
				}
					
			}
        }
		$data['role']=sql::row("user_role","role_id='{$_REQUEST['id']}'");
        $data['header_title'] = "Role Add";
        $data['action'] = site_url('users/add_role');
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Role Edit";
        $data['page'] = 'edit_role';
        $this->load->view('main', $data);
    }


    function edit_user() {
		$id=$_REQUEST['id'];
		if ($_POST['save']) {
			if ($this->mod_users->update_user($id)) {
				$this->session->set_flashdata('success_msg', 'Users was Updated Successfully!!!');
				redirect('?c=users&m=index');
			}
        }
		$data=sql::row("users","user_id='{$id}'");
        $data['header_title'] = "Add user";
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Users Add";
        $data['page'] = 'edit_user';
        $this->load->view('main', $data);
    }

    function user_name_check() {
        $str = $_POST['user_name'];
        $id = $this->uri->segment(3) - ID_GENERATE;
        $con = "";
        if ($id) {
            $con.=" and user_id<>'$id'";
        }
        if (sql::count('users', "user_name='$str' $con") > 0) {
            $this->form_validation->set_message('user_name_check', 'This User Name already used in another account.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    function user_status($id='', $status='') {
        if (!common::is_admin_logged()) {
            $this->session->set_flashdata("msg", "Unathorized User");
            redirect("users");
        }
        if ($id == '' || $status == '') {
            redirect("users");
        }
        $this->db->query("update users set user_status='$status' where user_id='$id'");
        $this->session->set_flashdata("msg", "Status updated successfully");
        redirect("users");
    }

    function delete_user() {
        $uid = $_REQUEST['id'];
        if (!common::is_admin_logged()) {
            $this->session->set_flashdata("msg", "Unathorized User");
              redirect("?c=users");
        }
        if ($uid == '') {
            redirect("?c=users");
        }
        $this->db->query("delete from users where user_id='$uid'");
        $this->session->set_flashdata("msg", "Row Deleted Successfully");
        redirect("?c=users");
    }
	function delete_role() {
        $uid = $_REQUEST['id'];
        if (!common::is_admin_logged()) {
            $this->session->set_flashdata("msg", "Unathorized User");
              redirect("?c=users&m=role");
        }
        if ($uid == '') {
            redirect("?c=users&m=role");
        }
        $this->db->query("delete from user_role where role_id='$uid'");
		 $this->db->query("delete from role_permission where role_id='$uid'");
        $this->session->set_flashdata("msg", "Row Deleted Successfully");
        redirect("?c=users&m=role");
    }
	function role_check() {
		$id=$_REQUEST['id'];
		$con="";
		if($id)
			$con=" and role_id<>'{$_REQUEST['id']}'";
        $valid = sql::count('user_role', "role_name='{$_POST['role_name']}'  $con");
	//	echo $this->db->last_query();exit;
        if ($valid > 0) {
			$this->form_validation->set_message('role_check', 'This is already taken');
            return false;
        } else {
            //$this->form_validation->set_message('role_check', 'This is already taken');
            return true;
        }
    }
   

}
?>