<?php

class staff extends CI_Controller {

    private $dir = 'staff';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_staff');
        common::is_logged();
		common::getExecuteQuery();
    }

    function index() {
		if(!common::page_permission("staff","addStaff")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_staff->get_staff_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('c=staff&m=index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_staff->get_staff_list($limit = true, $start, $config['per_page']);
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		$data['users']=sql::row("users","user_id='{$id}'");
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Staffs";
        $data['page_title'] = 'Staffs';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	
	function save_staff(){
		if(!common::page_permission("staff","addStaff")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Zone', 'required');
		$this->form_validation->set_rules('branch_id', 'Zone', 'required');
		$this->form_validation->set_rules('staff_no', 'Staff ID', 'required|callback_check_staff_no');
		$this->form_validation->set_rules('full_name', 'Full Name', 'required');
		$this->form_validation->set_rules('designation_id', 'Designation', 'required');
		$this->form_validation->set_rules('joining_date', 'Joining Date', 'required');
		$this->form_validation->set_rules('mobile_no', 'Mobile No', 'required');
		$this->form_validation->set_rules('current_salary', 'Salary', 'required|callback_salary_non_zero');
		if ($this->form_validation->run() == false) {
            $data = array(
                'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'staff_no' => form_error('staff_no'),
				'full_name' => form_error('full_name'),
				'designation_id' => form_error('designation_id'),
				'joining_date' => form_error('joining_date'),
				'mobile_no' => form_error('mobile_no'),
				'current_salary' => form_error(current_salary),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_staff->save_staff();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function edit_staff_info(){
		if(!common::page_permission("staff","editStaff")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Zone', 'required');
		$this->form_validation->set_rules('branch_id', 'Zone', 'required');
		$this->form_validation->set_rules('staff_no', 'Staff ID', 'required|callback_check_staff_no');
		$this->form_validation->set_rules('full_name', 'Full Name', 'required');
		$this->form_validation->set_rules('designation_id', 'Designation', 'required');
		$this->form_validation->set_rules('joining_date', 'Joining Date', 'required');
		$this->form_validation->set_rules('mobile_no', 'Mobile No', 'required');
		if ($this->form_validation->run() == false) {
            $data = array(
                'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'staff_no' => form_error('staff_no'),
				'full_name' => form_error('full_name'),
				'designation_id' => form_error('designation_id'),
				'joining_date' => form_error('joining_date'),
				'mobile_no' => form_error('mobile_no')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_staff->edit_staff();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record updated Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function salary_non_zero(){
		if ($_REQUEST['current_salary']==0 || $_REQUEST['current_salary']=="") {
            $this->form_validation->set_message('salary_non_zero', 'The Current Salary  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function add_staff() {
        if(!common::page_permission("staff","addStaff")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['upload']=true;
        $data['header_title'] = "Add Staff";
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Staffs Add";
        $data['page'] = 'new_staff';
        $this->load->view('main', $data);
    }
    function edit_staff() {
		if(!common::page_permission("staff","editStaff")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $data=sql::row("staff","staff_id='{$_REQUEST['id']}'");
		$this->session->set_userdata("staff_photo",$data['staff_photo']);
		$data['id']=$_REQUEST['id'];
		$data['upload']=true;
        $data['header_title'] = "Edit Staff";
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Staffs Edit";
        $data['page'] = 'edit_staff';
        $this->load->view('main', $data);
    }

    function check_staff_no() {
        $str = $_POST['staff_no'];
        $id = $this->uri->segment(3) - ID_GENERATE;
        $con = "";
        if ($id) {
            $con.=" and staff_id<>'$id'";
        }
        if (sql::count('staff', "staff_no='$staff_no' $con") > 0) {
            $this->form_validation->set_message('check_staff_no', 'This ID already used in another account.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    
    function delete_staff() {
		if(!common::page_permission("staff","deleteStaff")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $uid = $_REQUEST['id'];
        if (!common::is_admin_logged()) {
            $this->session->set_flashdata("msg", "Unathorized User");
              redirect("?c=staff");
        }
        if ($uid == '') {
            redirect("?c=staff");
        }
        $this->db->query("update staff set status='2' where staff_id='{$_REQUEST['id']}'");
        $this->session->set_flashdata("success_msg", "Row Deleted Successfully");
        redirect("?c=staff");
    }
	function upload_photo(){
		echo $this->mod_staff->save_photo($this->session->userdata('content'));
	}
	function show_salary(){
		$data['salary']=sql::rows("staff_salary","staff_id='{$_REQUEST['id']}' order by effective_date desc");
		$data['dir'] = $this->dir;
		$data['page']="salary_details";
		$this->load->view('main_ajax_content',$data);
	}
	function show_center(){
		$data['center']=$this->mod_staff->get_center_details($_REQUEST['id']);
		$data['dir'] = $this->dir;
		$data['page']="center_details";
		$this->load->view('main_ajax_content',$data);
	}
   

}
?>