<?php
class savings_account_report extends CI_Controller {
    private $dir = 'savings_account_report';
    function __construct() {
        parent::__construct();
        common::is_logged();
		
		$this->load->model("mod_member");
		$this->load->model("mod_saving_account");
		common::getExecuteQuery();
    }
	function index(){
		if(!common::page_permission("saving_account_report","savingAccountReport")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['dir'] = $this->dir;
		$data['staff']=$this->mod_member->get_staff_list();
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Savings Account Report";
        $data['page_title'] = 'Savings Account Report';
        $data['page'] = 'savings_account_report';
        $this->load->view('main', $data);
	}
	function close_account(){
		if(!common::page_permission("saving_account_report","savingCloseAccountReport")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Close Account Report";
        $data['page_title'] = 'Close Account Report';
        $data['page'] = 'savings_account_report_close';
        $this->load->view('main', $data);
	}
	function generate_account_report_close(){
		if(!common::page_permission("saving_account_report","savingCloseAccountReport")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		extract($_REQUEST);
		$this->load->view("savings_account_report/generate_account_report_close",$data);
	}
	
	function generate_account_interest(){
		if(!common::page_permission("saving_account_report","savingAccountStatement")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		extract($_REQUEST);
		$this->load->view("savings_account_report/generate_account_interest_report",$data);
	}
	function generate_account_report(){
		if(!common::page_permission("saving_account_report","savingAccountReport")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		extract($_REQUEST);
		$this->load->view("savings_account_report/generate_account_report",$data);
	}
	function withdraw(){
		if(!common::page_permission("saving_account_report","savingWithdrawReport")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Withdraw Report";
        $data['page_title'] = 'Withdraw Report';
        $data['page'] = 'withdraw_report';
        $this->load->view('main', $data);
	}
	function generate_withdraw_report(){
		if(!common::page_permission("saving_account_report","savingWithdrawReport")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		extract($_REQUEST);
		$this->load->view("savings_account_report/generate_withdraw_report",$data);
	}
	function account_statement(){
		if(!common::page_permission("saving_account_report","savingAccountStatement")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Account Statement";
        $data['page_title'] = 'Account Statement';
        $data['page'] = 'account_statement';
        $this->load->view('main', $data);
	}
	function account_interest(){
		if(!common::page_permission("saving_account_report","savingAccountInterest")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Account Interest Report";
        $data['page_title'] = 'Account Interest Report';
        $data['page'] = 'account_interest';
        $this->load->view('main', $data);
	}
	function search_saving_account(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_saving_account';
        $this->load->view('main_ajax_content', $data);
	}
	function saving_account_list(){
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_saving_account->get_member_saving_account_all_data();
		$data['dir'] = $this->dir;
        $data['page'] = 'member_saving_account_list';
        $this->load->view('main_ajax_content', $data);
	}
	function generate_account_transaction(){
		if(!common::page_permission("saving_account_report","savingAccountStatement")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		extract($_REQUEST);
		$this->load->view("savings_account_report/generate_account_transaction",$data);
	}
	
}

?>