<?php

class saving_account extends CI_Controller {

    private $dir = 'saving_account';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_saving_account');
        common::is_logged();
		common::getExecuteQuery();
    }
	function index() {
	if(!common::page_permission("saving","viewSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_saving_account->get_account_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('saving_account/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_saving_account->get_account_list($limit = true, $start, $config['per_page']);
        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Account Information";
        $data['page_title'] = 'Account Information';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	function close_request_status() {
		if(!common::page_permission("saving","closeSavingRequestStatus")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_saving_account->get_close_account_request_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('saving_account/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_saving_account->get_close_account_request_list($limit = true, $start, $config['per_page']);
        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Request Status";
        $data['page_title'] = 'Request Status';
        $data['page'] = 'close_request_status';
        $this->load->view('main', $data);
    }
	function add_account() {
		if(!common::page_permission("saving","addSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['settings']=sql::rows("savings_account_settings","account_type=2 order by year asc");
        $data['header_title'] = "Savings Account";
        $data['page_title'] = 'Savings Account';
		$data['dir']=$this->dir;
        $data['page'] = 'new_account';
        $this->load->view('main', $data);
    }
	function edit_account() {
		if(!common::page_permission("saving","editSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$id=$_REQUEST['id'];
		
		$data=$this->mod_saving_account->get_account_data($id);
        $data['header_title'] = "Savings Account Edit";
        $data['page_title'] = 'Savings Account Edit';
		$data['dir']=$this->dir;
        $data['page'] = 'edit_account';
        $this->load->view('main', $data);
    }
	function edit_saving_account(){
		if(!common::page_permission("saving","editSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|xss_clean|numeric|callback_check_amount_non_zero');
		$this->form_validation->set_rules('is_account_applicable', '', 'callback_is_account_applicable');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date'),
				'amount' => form_error('amount'),
				'is_account_applicable'=>form_error('is_account_applicable')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			//echo $_REQUEST['id'];exit;
			$id=$this->mod_saving_account->edit_account($_REQUEST['account_id']);
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function save_account(){
		if(!common::page_permission("saving","addSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_check_valid_member_id');
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|xss_clean|numeric|callback_check_amount_non_zero');
		$this->form_validation->set_rules('is_account_applicable', '', 'callback_is_account_applicable');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no'),
				'date' => form_error('date'),
				'amount' => form_error('amount'),
				'is_account_applicable' => form_error('is_account_applicable')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_saving_account->add_account();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function check_valid_member_id() {
        $member_no = $_POST['member_no'];
		$member_id = $_POST['member_id'];
        if ($_REQUEST['id']) {
            $con.=" and member_id<>'{$_REQUEST['id']}'";
        }
		$member=sql::row('members', "member_no='$member_no' and member_id='{$member_id}' and is_black=0 $con");
        if ($member['member_id']=="") {
            $this->form_validation->set_message('check_valid_member_id', 'Invalid Member ID');
            return FALSE;
        }
		else {
            return TRUE;
        }
    }
	 function valid_member_id() {
        $member_no = $_POST['member_no'];
		$member_id = $_POST['member_id'];
		
		$member=sql::row('members', "member_no='$member_no' and member_id='{$member_id}' $con");
        if ($member['member_id']=="") {
            $this->form_validation->set_message('valid_member_id', 'Invalid Member ID');
            return FALSE;
        }
		else {
            return TRUE;
        }
    }
	
	function is_account_applicable(){
		$member_id = $_POST['member_id'];
		$account_type=$_REQUEST['account_type'];
		$con="";
		if($_REQUEST['account_id'])
			$con=" and account_id<>'{$_REQUEST['account_id']}'";
		$row=sql::row("saving_account","member_id='{$member_id}' and account_type='{$account_type}'  and center_id='{$_REQUEST['center_id']}' $con and status=1");
		if(count($row)>0){
			$this->form_validation->set_message('is_account_applicable', 'You are not allowed to this account');
            return FALSE;
		}
		 else {
            return TRUE;
        }
	}
	
	function check_amount_non_zero(){
		if ($_REQUEST['amount']==0) {
            $this->form_validation->set_message('check_amount_non_zero', 'The  amount  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function withdraw() {
		
		if(!common::page_permission("saving","withdrawSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $data['header_title'] = "Withdraw";
        $data['page_title'] = 'Withdraw';
		$data['dir']=$this->dir;
        $data['page'] = 'withdraw';
        $this->load->view('main', $data);
    }
	function search_id_card(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_id_card';
        $this->load->view('main_ajax_content', $data);
	}
	function member_list(){
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_saving_account->get_member_saving_account_data();
		$data['dir'] = $this->dir;
        $data['page'] = 'member_list';
        $this->load->view('main_ajax_content', $data);
	}
	function withdraw_account(){
		//print_r($_REQUEST);exit;
		if(!common::page_permission("saving","withdrawSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id');
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|xss_clean|numeric|callback_check_amount_non_zero');
		$this->form_validation->set_rules('is_balance_applicable', '', 'callback_is_balance_applicable');
		$this->form_validation->set_rules('is_close_request', '', 'callback_is_close_request');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no'),
				'date' => form_error('date'),
				'amount' => form_error('amount'),
				'is_balance_applicable' => form_error('is_balance_applicable'),
				'is_close_request' => form_error('is_close_request')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_saving_account->add_withdraw();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	
	function is_balance_applicable(){
		$member_id = $_POST['member_id'];
		$account_id=$_REQUEST['account_id'];
		$con="";
		$row=sql::row("saving_account","member_id='{$member_id}' and account_id='{$account_id}'  and center_id='{$_REQUEST['center_id']}' $con and status=1");
		if($_REQUEST['amount']>0&&($_REQUEST['amount']>$row['balance'])){
			$this->form_validation->set_message('is_balance_applicable', 'Your amount is exceed in your current balance');
            return FALSE;
		}
		 else {
            return TRUE;
        }
	}
	function close(){
		if(!common::page_permission("saving","closeSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->session->unset_userdata("saving_account_id");
		$this->session->unset_userdata("request_id");
		$data['header_title'] = "Close Account";
        $data['page_title'] = 'Close Account';
		$data['dir']=$this->dir;
        $data['page'] = 'closing';
        $this->load->view('main', $data);
	}
	function close_request(){
		if(!common::page_permission("saving","closeSavingRequest")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->session->unset_userdata("saving_account_request_id");
		$data['header_title'] = "Close Request";
        $data['page_title'] = 'Close Request';
		$data['dir']=$this->dir;
        $data['page'] = 'close_request';
        $this->load->view('main', $data);
	}
	function search_member_saving_account(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
		$data['close_request']=$_REQUEST['close_request'];
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_member_saving_account';
        $this->load->view('main_ajax_content', $data);
	}
	function search_member_saving_account_request(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_member_saving_account_request';
        $this->load->view('main_ajax_content', $data);
	}
	function member_saving_account_list(){
		
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_saving_account->get_member_saving_account_data();
		$data['dir'] = $this->dir;
        $data['page'] = 'member_saving_account_list';
        $this->load->view('main_ajax_content', $data);
	}
	function member_saving_account_request_list(){
		
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_saving_account->get_member_saving_account_request_data();
		$data['dir'] = $this->dir;
        $data['page'] = 'member_saving_account_request_list';
        $this->load->view('main_ajax_content', $data);
	}
	function close_account_step1(){
		if(!common::page_permission("saving","closeSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id_saving_account');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			//print_r($_REQUEST);
			if($_REQUEST['account_id'] && $_REQUEST['request_id']){
				$this->session->set_userdata("saving_account_id",$_REQUEST['account_id']);
				$this->session->set_userdata("request_id",$_REQUEST['request_id']);
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully','account_id'=>(ID_GENERATE+$_REQUEST['account_id']),'request_id'=>(ID_GENERATE+$_REQUEST['request_id']));
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function close_account_request_step1(){
		if(!common::page_permission("saving","closeSavingRequest")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id_saving_account');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			if($_REQUEST['account_id']){
				$this->session->set_userdata("saving_account_request_id",$_REQUEST['account_id']);
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully','account_id'=>(ID_GENERATE+$_REQUEST['account_id']));
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function valid_member_id_saving_account(){
		 $member_no = $_POST['member_no'];
		 $member_id = $_POST['member_id'];
		 $query=$this->db->query("select saving_account.account_id, members.member_no from saving_account left join members on members.member_id=saving_account.member_id where saving_account.status=1 and members.status=1 and members.member_id='{$member_id}' and members.member_no='{$member_no}' and saving_account.member_id='{$member_id}' and saving_account.account_id='{$_REQUEST['account_id']}'");
		 $row=$query->row_array();
		 if($row['account_id']>0){
			 return true;
		 } else {
			$this->form_validation->set_message('valid_member_id_saving_account', 'Invalid Member ID');
            return false;
        }
	}
	function close_account_request_step2($id=''){
		if(!common::page_permission("saving","closeSavingRequest")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$dps_account_id=$this->session->userdata("saving_account_request_id");
		$account_id=$id-ID_GENERATE;
		if($dps_account_id!=$account_id)
		{
			$this->session->set_flashdata("warning_msg","Bad request you are applying");
			redirect("saving_account/close_request");
		}
		else{
			$data['account']=$this->mod_saving_account->get_saving_account_data($account_id);
			$data['header_title'] = "Close Account Request";
			$data['page_title'] = 'Close Account Request';
			$data['dir']=$this->dir;
			$data['page'] = 'closing_request_final';
			$this->load->view('main', $data);
		}
	}
	function close_account_step2($id='',$request_id=''){
		if(!common::page_permission("saving","closeSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$dps_account_id=$this->session->userdata("saving_account_id");
		$session_request_id=$this->session->userdata("request_id");
		$account_id=$id-ID_GENERATE;
		$request_id=$request_id-ID_GENERATE;
		if($dps_account_id!=$account_id)
		{
			$this->session->set_flashdata("warning_msg","Bad request you are applying");
			redirect("saving_account/close");
		}
		else if($session_request_id!=$request_id)
		{
			$this->session->set_flashdata("warning_msg","Bad request you are applying");
			redirect("saving_account/close");
		}
		else{
			$data['account']=$this->mod_saving_account->get_member_saving_account_request_data1($account_id,$request_id);
			$data['header_title'] = "Close Account";
			$data['page_title'] = 'Close Account';
			$data['dir']=$this->dir;
			$data['page'] = 'closing_final';
			$this->load->view('main', $data);
		}
	}
	function close_account_request(){
		if(!common::page_permission("saving","closeSavingRequest")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('account_id', 'Account ID', 'callback_is_valid_saving_account_request');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date'),
				'account_id' => form_error('account_id')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_saving_account->close_account_request($_REQUEST['account_id']);
			if($id){
				$this->session->set_flashdata("success_msg","Account Closed Request Has been sent  Successfully");
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function close_account(){
		if(!common::page_permission("saving","closeSaving")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('account_id', 'Account ID', 'callback_is_valid_saving_account');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date'),
				'account_id' => form_error('account_id')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_saving_account->close_account($_REQUEST['account_id'],$_REQUEST['request_id']);
			if($id){
				$this->session->set_flashdata("success_msg","Account Closed Successfully");
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function is_valid_saving_account(){
		$account_id = $_POST['account_id'];
		$session_account_id = $this->session->userdata("saving_account_id");
		$account=sql::row("saving_account","account_id='{$account_id}' and status=1");
        if ($account_id!=$session_account_id ) {
            $this->form_validation->set_message('is_valid_saving_account', 'Invalid Request');
            return FALSE;
        } 
		else if ($account['account_id']=="") {
            $this->form_validation->set_message('is_valid_saving_account', 'Invalid Account');
            return FALSE;
        }
		else {
            return TRUE;
        }
	}
	function is_valid_saving_account_request(){
		$account_id = $_POST['account_id'];
		$session_account_id = $this->session->userdata("saving_account_request_id");
		$account=sql::row("saving_account","account_id='{$account_id}' and status=1");
        if ($account_id!=$session_account_id ) {
            $this->form_validation->set_message('is_valid_saving_account_request', 'Invalid Request');
            return FALSE;
        } 
		else if ($account['account_id']=="") {
            $this->form_validation->set_message('is_valid_saving_account_request', 'Invalid Account');
            return FALSE;
        }
		else {
            return TRUE;
        }
	}
	
	function view_request($id){
		$account_id=$id-ID_GENERATE;
		if(!common::page_permission("saving","closeSavingViewRequest")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		 if(!$this->valid_request_id($account_id)){
			$this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect(); 
		 }
		
		$data['account']=$this->mod_saving_account->get_saving_account_request_data($account_id);
		$data['id']=$id;
		$data['header_title'] = "Close Account";
		$data['page_title'] = 'Close Account';
		$data['dir']=$this->dir;
		$data['page'] = 'view_request';
		$this->load->view('main', $data);
		
	}
	function valid_request_id($id){
		$row=sql::row("saving_account_close_request","id='{$id}' and status<>2","id");
		if($row['id'])
			return true;
		else
			return false;
	}
	function valid_request_id_reject($id){
		$row=sql::row("saving_account_close_request","id='{$id}' and status=0","id");
		if($row['id'])
			return true;
		else
			return false;
	}
	function reject_request($id){
		 $account_id=$id-ID_GENERATE;
		// echo $_REQUEST['id']."<br/>".$id;exit;
		 if($this->valid_request_id_reject($account_id) && $_REQUEST['id']==$id){
			// echo "sssss";exit;
			 $this->db->query("delete from  saving_account_close_request  where id='{$account_id}'");
			  $this->db->query("update   saving_account  set is_close_request=0, close_request_id=0 where close_request_id='{$account_id}'");
			  $this->session->set_flashdata("success_msg","Close request has been rejected");
			  $array = array('status' => 'success', 'error' => '', 'message' => 'Close request has been approved');
				echo json_encode($array);
		 }
		 else{
			 $array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
		 }
	}
	function approved_request($id){
		 $account_id=$id-ID_GENERATE;
		// echo $_REQUEST['id']."<br/>".$id;exit;
		 if($this->valid_request_id($account_id) && $_REQUEST['id']==$id){
			 $this->db->query("update saving_account_close_request set status=1 ,percentage='{$_REQUEST['interest_rate']}',interest_amount='{$_REQUEST['interest_amount']}' where id='{$account_id}'");
			  $array = array('status' => 'success', 'error' => '', 'message' => 'Close request has been approved');
				echo json_encode($array);
		 }
		 else{
			 $array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
		 }
	}
	function is_close_request(){
		$member_id = $_POST['member_id'];
		$account_id=$_REQUEST['account_id'];
		$row=sql::row("saving_account","member_id='{$member_id}' and account_id='{$account_id}'  and center_id='{$_REQUEST['center_id']}' and is_close_request=1 $con and status=1");
		if($row['account_id']>0){
			$this->form_validation->set_message('is_close_request', 'You can not withdraw from this account as this account is under close');
            return FALSE;
		}
		 else {
            return TRUE;
        }
	}
	
	
}
?>