<?php

class member extends CI_Controller {

    private $dir = 'member';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_member');
        common::is_logged();
		common::getExecuteQuery();
    }

    function index() {
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_member->get_member_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('member/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_member->get_member_list($limit = true, $start, $config['per_page']);
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Members";
        $data['page_title'] = 'Members';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }

    function add() {
		 if(!common::page_permission("member","addMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        
		$data['upload']=true;
        $data['header_title'] = "Member Entry (সদস্য যোগ)";
        $data['action'] = site_url('member/add');
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
        $data['page_title'] = "Member Entry (সদস্য যোগ)";
        $data['page'] = 'new_member';
        $this->load->view('main', $data);
    }

    function edit_member() {
		 if(!common::page_permission("member","editMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$id=$_REQUEST['id'];
        
        $data['users'] = sql::row("members", "member_id='$id'");
		$this->session->set_userdata("content",$data['users']['photo']);
		$this->session->set_userdata("nominee_photo",$data['users']['nominee_photo']);
		$data['center_list']=common::get_center_list($data['users']['center_id']);
        $data['header_title'] = "Members";
		$data['uid']=$uid;
		$data['id']=$id;
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
		$data['save']=true;
		$data['cancel']=true;
		$data['upload']=true;
        $data['page_title'] = "Member Edit (সদস্য যোগ)";
        $data['page'] = 'edit_member';
        $this->load->view('main', $data);
    }
	function save_member(){
		if(!common::page_permission("member","addMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('branch_id', 'Branch', 'required');
		$this->form_validation->set_rules('center_id', 'Center', 'required');
		$this->form_validation->set_rules('member_name', 'Member Name', 'required');
		$this->form_validation->set_rules('joining_date', 'Joining Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('national_id_no', 'Narional ID No', 'required|trim|callback_duplicate_national_no');
		$this->form_validation->set_rules('member_no', 'Member No', 'required|trim|callback_duplicate_member_no');
		if ($this->form_validation->run() == false) {
            $data = array(
				'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'center_id' => form_error('center_id'),
				'member_name' => form_error('member_name'),
				'member_name' => form_error('member_name'),
                'member_no' => form_error('member_no'),
				'joining_date' => form_error('joining_date'),
				'national_id_no' => form_error('national_id_no')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			if ($this->mod_member->save_member()) {
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function save_edit_member(){
		if(!common::page_permission("member","editMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('branch_id', 'Branch', 'required');
		$this->form_validation->set_rules('center_id', 'Center', 'required');
		$this->form_validation->set_rules('member_name', 'Member Name', 'required');
		$this->form_validation->set_rules('joining_date', 'Joining Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('member_no', 'Member No', 'required|trim|callback_duplicate_member_no');
		if ($this->form_validation->run() == false) {
            $data = array(
				'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'center_id' => form_error('center_id'),
				'member_name' => form_error('member_name'),
				'member_name' => form_error('member_name'),
                'member_no' => form_error('member_no'),
				'joining_date' => form_error('joining_date')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			if ($this->mod_member->update_member($_REQUEST['member_id'])) {
				$this->session->set_flashdata("success_msg","Record Updated Successfully");
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}

    

    function delete_member() {
		if(!common::page_permission("member","deleteMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $uid = $_REQUEST['id'];
        if (!common::is_admin_logged()) {
            $this->session->set_flashdata("msg", "Unathorized User");
              redirect("?c=member");
        }
        if ($uid == '') {
            redirect("?c=member");
        }
		$member=sql::row("member_share","member_id='{$uid}'");
		//print_r($member);exit;
		$this->db->query("delete from member_share where member_id='{$uid}'");
		$this->db->query("delete from balance where share_id='{$member['share_id']}'");
        $this->db->query("delete from  members  where member_id='$uid'");
        $this->session->set_flashdata("msg", "Row Deleted Successfully");
        redirect("?c=member");
    }
	function upload_photo(){
		echo $this->mod_member->save_photo($this->session->userdata('content'));
	}
	function upload_nominee_photo(){
		echo $this->mod_member->save_nominee_photo($this->session->userdata('nominee_photo'));
	}
	function search_id_card(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_id_card';
        $this->load->view('main_ajax_content', $data);
	}
	function search_member_for_death(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_member_for_death';
        $this->load->view('main_ajax_content', $data);
	}
	function search_member(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_member';
        $this->load->view('main_ajax_content', $data);
	}
	function search_member_for_black_list(){
		$data['branch_list']=common::get_branch_list();
		$data['center_list']=common::get_center_list();
		$data['id']=$id;
        $data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_member_for_black_list';
        $this->load->view('main_ajax_content', $data);
	}
	
	function show_member_list_for_black_list(){
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_member->get_member_data_for_black_list();
		$data['dir'] = $this->dir;
        $data['page'] = 'show_member_list_for_black_list';
        $this->load->view('main_ajax_content', $data);
	}
	function show_member_list(){
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_member->get_member_data();
		$data['dir'] = $this->dir;
        $data['page'] = 'show_member_list';
        $this->load->view('main_ajax_content', $data);
	}
	function show_member_list_for_death(){
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_member->get_member_data_for_deatch();
		$data['dir'] = $this->dir;
        $data['page'] = 'show_member_list_for_death';
        $this->load->view('main_ajax_content', $data);
	}
	function member_list(){
		$data['center_name']=common::center_list_array();
		$data['center_no']=common::center_list_array('id');
		$data['branch_name']=common::branch_list_array();
		$data['member']=$this->mod_member->get_member_data();
		$data['dir'] = $this->dir;
        $data['page'] = 'member_list';
        $this->load->view('main_ajax_content', $data);
	}
	function member_basic_data(){
		if($_REQUEST['member_no']!="")
		{
			$sql = "SELECT * FROM members WHERE member_no = '{$_REQUEST['member_no']}'";
			$query=$this->db->query($sql);
			$row=$query->row_array();
		}
		$center=common::center_list_array("id");
		if(count($row)>0){
			echo '$j("#member_no").val("'.$this->db->escape_like_str($row["member_no"]).'");'."\n";
			echo '$j("#member_name").val("'.$this->db->escape_like_str($row["member_name"]).'");'."\n";	
			echo '$j("#center_no").val("'.$this->db->escape_like_str($center[$row["center_id"]]).'");'."\n";	
			echo '$j("[name=center_id]").val("'.$this->db->escape_like_str($row["center_id"]).'");'."\n";	
			echo '$j("#joining_date").val("'.$this->db->escape_like_str($row["joining_date"]).'");'."\n";	
			exit();
		}
		else{
			echo "0";
		}
	}
	function update_member(){
		$rows=sql::rows("members");
		foreach($rows as $r){
$this->db->query("update balance set zone_id='{$r['zone_id']}',area_id='{$r['area_id']}',branch_id='{$r['branch_id']}' where member_id='{$r['member_id']}'");
$this->db->query("update member_share set zone_id='{$r['zone_id']}',area_id='{$r['area_id']}',branch_id='{$r['branch_id']}' where member_id='{$r['member_id']}'");
		}
	}
	function show_member(){
		$data=$this->mod_member->get_member_single_data($_REQUEST['id']);
		$data['dir'] = $this->dir;
		$data['page']="member_details";
		$this->load->view('main_ajax_content',$data);
	}
   function close(){
		if(!common::page_permission("saving","closeMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->session->unset_userdata("member_account_id");
		$data['header_title'] = "Close Member";
        $data['page_title'] = 'Close Member';
		$data['dir']=$this->dir;
        $data['page'] = 'closing';
        $this->load->view('main', $data);
	}
	function death_claim(){
		if(!common::page_permission("member","deathMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->session->unset_userdata("member_account_id");
		$data['header_title'] = "Member death claim";
        $data['page_title'] = 'Member death claim';
		$data['dir']=$this->dir;
        $data['page'] = 'death_claim';
        $this->load->view('main', $data);
	}
	 function black_member(){
		if(!common::page_permission("member","blackMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }

		$data['header_title'] = "Black Member";
        $data['page_title'] = 'Black Member';
		$data['dir']=$this->dir;
        $data['page'] = 'black_member';
        $this->load->view('main', $data);
	}
	function save_black_member(){
		if(!common::page_permission("member","blackMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id_for_black');
		$this->form_validation->set_rules('date', 'Date', 'required');
		$this->form_validation->set_rules('reason_id', 'Reason', 'required');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no'),
				'date' => form_error('date'),
				'reason_id' => form_error('reason_id')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			if ($this->mod_member->save_black_member()) {
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function death_member_save1(){
		if(!common::page_permission("member","deathMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id_for_death');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			if($_REQUEST['member_id']){
				$this->session->set_userdata("member_account_id",$_REQUEST['member_id']);
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully','member_account_id'=>(ID_GENERATE+$_REQUEST['member_id']));
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function member_death_account_save(){
		
		if(!common::page_permission("member","deathMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			
			$member_account_id=$this->session->userdata("member_account_id");
			$id=$_REQUEST['id'];
			$account_id=$id-ID_GENERATE;
			if($account_id!=$member_account_id)
			{
				$this->session->set_flashdata("warning_msg","Bad request you are applying");
				 $array = array('status' => 'bad', 'error' => 'Bad request you are applying', 'message' => '','redirect'=>"member/death_claim");
				 echo json_encode($array);
			}
			else{
				$id=$this->mod_member->death_member($_REQUEST['member_id']);
			if($id){
				$this->session->set_flashdata("success_msg","Account has been moved to death account");
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
		}
	}
	
	function death_member_save2($id=''){
		if(!common::page_permission("member","deathMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		 $member_account_id=$this->session->userdata("member_account_id");
		 $account_id=$id-ID_GENERATE;
		if($member_account_id!=$account_id)
		{
			$this->session->set_flashdata("warning_msg","Bad request you are applying");
			redirect("member/death_claim");
		}
		else{
			$data['loan']=sql::rows("loan","member_id='{$account_id}' and status=1");
			$data['member']=$this->mod_member->get_member_single_data($account_id);
			$data['header_title'] = "Member Death Claim";
			$data['page_title'] = 'Member Death Claim';
			$data['dir']=$this->dir;
			$data['id']=$id;
			$data['page'] = 'member_death_claim_data';
			$this->load->view('main', $data);
		}
	}
	function close_member_account_step1(){
		if(!common::page_permission("saving","closeMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			if($_REQUEST['member_id']){
				$this->session->set_userdata("member_account_id",$_REQUEST['member_id']);
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully','member_account_id'=>(ID_GENERATE+$_REQUEST['member_id']));
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function valid_member_id_for_death(){
		 $member_no = $_POST['member_no'];
		 $member_id = $_POST['member_id'];
		 $query=$this->db->query("select * from members where status=1 and member_id='{$member_id}' and member_no='{$member_no}' and is_death=0");
		 $row=$query->row_array();
		 if($row['member_id']>0){
			 return true;
		 } else {
			$this->form_validation->set_message('valid_member_id_for_death', 'Invalid Member ID');
            return false;
        }
	}
	function valid_member_id_for_black(){
		 $member_no = $_POST['member_no'];
		 $member_id = $_POST['member_id'];
		 $query=$this->db->query("select * from members where status=1 and member_id='{$member_id}' and member_no='{$member_no}' and is_black=0");
		 $row=$query->row_array();
		 if($row['member_id']>0){
			 return true;
		 } else {
			$this->form_validation->set_message('valid_member_id_for_black', 'Invalid Member ID');
            return false;
        }
	}
	function valid_member_id(){
		 $member_no = $_POST['member_no'];
		 $member_id = $_POST['member_id'];
		 $query=$this->db->query("select * from members where status=1 and member_id='{$member_id}' and member_no='{$member_no}'");
		 $row=$query->row_array();
		 if($row['member_id']>0){
			 return true;
		 } else {
			$this->form_validation->set_message('valid_member_id', 'Invalid Member ID');
            return false;
        }
	}
	function duplicate_member_no(){
		$member_no = trim($_POST['member_no']);
		$member_id=$_REQUEST['member_id'];
		$branch_id=$_REQUEST['branch_id'];
		$center_id=$_REQUEST['center_id'];
		if($member_id){
			$con=" and member_id<>'{$member_id}'";
		}
		$row = sql::row("members", "member_no='{$member_no}' and center_id='{$center_id}' $con", "member_id");
		if($row['member_id']>0){
			$this->form_validation->set_message('duplicate_member_no', 'This ID already exists. Please try another');
			 return false;
		 } else {
            return true;
        }
	}
	function duplicate_national_no(){
		$member_id=$_REQUEST['member_id'];
		$national_id_no=trim($_REQUEST['national_id_no']);
		if($member_id){
			$con=" and member_id<>'{$member_id}'";
		}
		$row = sql::row("members", "national_id_no='{$national_id_no}' $con", "member_id");
		if($row['member_id']>0){
			$this->form_validation->set_message('duplicate_national_no', 'This National ID already exists. Please try another');
			 return false;
		 } else {
            return true;
        }
	}
	function close_member_account_step2($id=''){
		if(!common::page_permission("saving","closeMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		 $member_account_id=$this->session->userdata("member_account_id");
		 $account_id=$id-ID_GENERATE;
		if($member_account_id!=$account_id)
		{
			$this->session->set_flashdata("warning_msg","Bad request you are applying");
			redirect("member/close");
		}
		else{
			$data['member_share']=sql::row("member_share","member_id='{$account_id}'");
			$data['saving_account']=sql::rows("saving_account","member_id='{$account_id}' and status=1");
			$data['dps_account']=sql::rows("dps_account","member_id='{$account_id}' and status=1");
			$data['loan']=sql::rows("loan","member_id='{$account_id}' and status=1");
			$data['member']=$this->mod_member->get_member_single_data($account_id);
			$data['header_title'] = "Close Account";
			$data['page_title'] = 'Close Account';
			$data['dir']=$this->dir;
			$data['page'] = 'closing_final';
			$this->load->view('main', $data);
		}
	}
	
	function close_member_account(){
		if(!common::page_permission("saving","closeMember")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('account_id', 'Account ID', 'callback_valid_member_id');
		$this->form_validation->set_rules('share_balance', 'Share Balance', 'callback_share_balance');
		$this->form_validation->set_rules('is_allow', 'Share Balance', 'callback_is_allow');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date'),
				'account_id' => form_error('account_id'),
				'share_balance'=>form_error('share_balance'),
				'is_allow'=>form_error('is_allow')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_member->close_member_account($_REQUEST['member_id']);
			if($id){
				$this->session->set_flashdata("success_msg","Account Closed Successfully");
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function is_allow(){
		$member_no = $_POST['member_no'];
		$member_id = $_POST['member_id'];
		$data['saving_account']=sql::rows("saving_account","member_id='{$member_id}' and status=1");
		$data['dps_account']=sql::rows("dps_account","member_id='{$member_id}' and status=1");
		$data['loan']=sql::rows("loan","member_id='{$member_id}' and status=1");
		if(count($data['saving_account'])>0 || count($data['dps_account'])>0 || count($data['loan'])>0){
			$this->form_validation->set_message('is_allow', 'You are not allowed to close this member');
            return false;
		}
		else{
			return true;
		}
	}
	function share_balance(){
		 $share_balance = $_POST['share_balance'];
		 if($share_balance>0){
			 return true;
		 } else {
			$this->form_validation->set_message('share_balance', 'Share Balance can not be blank');
            return false;
        }
	}
	function update_share_transaction(){
		$rows=sql::rows("member_share");
		foreach($rows as $s){
			$data=array("transaction_type"=>1,"member_id"=>$s['member_id'],"zone_id"=>$s['zone_id'],"branch_id"=>$s['branch_id'],"area_id"=>$s['area_id'],"center_id"=>$s['center_id'],"share_account_id"=>$s['share_id'],"amount"=>$s['share_amount'],"date"=>$s['date'],"created_date"=>$s['date']);
			$this->db->insert("member_share_transaction",$data);
		}
	}
	
	function send_sms_text(){
		$text="Dada, 40000 paici. eta to service maintanance er charge e ase but addiotional kajer jonno ki dilen..ami jodio apnar service maintanance charge bad diye dilam jotodin additional kaj colbe.";
$msg=iconv(mb_detect_encoding($text, mb_detect_order(), true), "UTF-8", $text);
		/************Xml Convert top array****/
		
		
				
				/*****Send SMS****/
			 include_once(APPPATH . '/lib/nusoap.php');
			$client = new nusoap_client("https://user.mobireach.com.bd/index.php?r=sms/service", true);
			
				$params = array(
					'Username' => "ruposhi",
					'Password' => "Sumon@3211",
					'From' => "RUPOSI",
					'To' => "8801796497540",
					'Message' =>$text
				);
				$result = $client->call('SendTextMultiMessage', $params);
				print_r($result);	
	}
	function monthly_interest(){

		$query=$this->db->query("select members.member_id,members.member_no,members.mobile_no,members.joining_date,members.center_id,
members.zone_id,members.area_id,members.branch_id,saving_account.* from saving_account left join members on members.member_id=saving_account.member_id where saving_account.status=1 and saving_account.account_type=3");
$k=0;

$date="2024-12-31";
		foreach($query->result_array() as $m){
			
			if(strtotime("2024-01-01")>strtotime($m['joining_date'])){
				$joining_date="2024-01-01";
			}
			else{
				$joining_date=$m['joining_date'];
			}
			//echo $joining_date."-";
			 $months=common::getNoMonth($joining_date);
			if($months>=6&&$m['balance']>0){
				echo $m['member_id']."<br/>";
				$user_id=$this->session->userdata("user_id");
				$balance=$m['balance'];
				$interest_rate=(3/12)*$months;
				$interest=$m['balance']*$interest_rate/100;
				$center_id=$m['center_id'];
				$zone_id=$m['zone_id'];
				$area_id=$m['area_id'];
				$branch_id=$m['branch_id'];
				$member_id=$m['member_id'];
				$balance=$balance+$interest;
				//$no_deposit=$balance/$row['amount'];
				$account_type=$m['account_type'];
			//	$interest_rate=(5/12)*$months;
				//$interest_rate=number_format((float)$interest_rate, 2, '.', '');
				//echo "Member:".$m['member_id']."joining_date:".$m['joining_date']." Months:".$months." Interest rate:".$interest_rate." Balance:".$m['balance']."<br/>";
				if($interest_rate>0 && $interest>0){
				$data=array(
						'member_id'=>$member_id,
						'center_id'=>$center_id,
						'zone_id'=>$zone_id,
						'area_id'=>$area_id,
						'branch_id'=>$branch_id,
						'date'=>$date,
						'transaction_type'=>3,
						'amount'=>$interest,
						'account_type'=>$account_type,
						'percentage'=>$interest_rate,
						'account_id'=>$m['account_id'],
						"create_by" => $user_id
						);
				$this->db->insert("saving_account_transaction",$data);
				$transaction_id=$this->db->insert_id();
				if($transaction_id>0){
					$balanse_data=array("zone_id"=>$zone_id,"area_id"=>$area_id,"branch_id"=>$branch_id,"center_id"=>$center_id,"date"=>date("Y-m-d"),"saving_transaction_id"=>$transaction_id,"saving_account_id"=>$m['account_id'],"member_id"=>$member_id,'transaction_type'=>3,'account_type'=>$account_type);
					$this->db->insert("balance",$balanse_data);
					$this->db->query("update saving_account set total_interest=total_interest+'{$interest}',balance={$balance} where account_id='{$m['account_id']}'");
					
					$interest_data=array("zone_id"=>$zone_id,"area_id"=>$area_id,"branch_id"=>$branch_id,"center_id"=>$center_id,"date"=>date("Y-m-d"),"saving_account_transaction_id"=>$transaction_id,"saving_account_id"=>$m['account_id'],"member_id"=>$member_id,"amount"=>$interest,"percentage"=>$interest_rate,"create_by" => $user_id,'balance'=>$balance);
					$this->db->insert("account_interest",$interest_data);
				}
				/**Send Measse**/
		if($m['mobile_no']){
				$message="Dear Member, \nYour account has been credited TK. BDT ".number_format($interest,2,'.',',')." as the yearly interst of Monthly Saving Account.\nYour current balance: ".number_format($balance,2,'.',',')."\nRUPOSI BANGLA";
					/*****Send SMS****/
				include_once(APPPATH . '/lib/nusoap.php');
			//	$client = new nusoap_client("https://user.mobireach.com.bd/index.php?r=sms/service", true);
				$params = array(
					'Username' => "ruposhi",
					'Password' => "Sumon@3211",
					'From' => "RUPOSI",
					'To' => "88".$m['mobile_no'],
					'Message' =>$message
				);
				//$result = $client->call('SendTextMultiMessage', $params);
								//$this->db->insert("message_log",$sms_data);
			}
		/**End**/
		}
		
		$k++;
			}
			
		}
		echo $k." data updated";
		//common::pr($rows);
	}

}
?>