<?php

class loan extends CI_Controller {

    private $dir = 'loan';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_loan');
        common::is_logged();
    }
	function index() {
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_loan->get_loan_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('loan/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_loan->get_loan_list($limit = true, $start, $config['per_page']);
        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Loan Information";
        $data['page_title'] = 'Loan Information';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	function loan_entry() {
		 if(!common::page_permission("loan","addLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data=common::get_settings_data();
        $data['header_title'] = "Loan Entry";
        $data['page_title'] = 'Loan Entry';
		$data['dir']=$this->dir;
        $data['page'] = 'new_loan';
        $this->load->view('main', $data);
    }
	function edit_loan() {
		if(!common::page_permission("loan","editLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$id=$_REQUEST['id'];
		$data=common::get_settings_data();
		$data=$this->mod_loan->get_loan_data($id);
        $data['header_title'] = "Loan Edit";
        $data['page_title'] = 'Loan Edit';
		$data['dir']=$this->dir;
        $data['page'] = 'edit_loan';
        $this->load->view('main', $data);
    }
	function save_loan(){
		if(!common::page_permission("loan","addLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id');
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('loan_amount', 'Loan Amount', 'required|trim|xss_clean|numeric|callback_check_loan_amount_non_zero');
		$this->form_validation->set_rules('service_charge', 'Service Charge', 'required|trim|xss_clean|numeric|callback_check_service_charge_non_zero');
		$this->form_validation->set_rules('total_installment', 'No of installment', 'required|trim|xss_clean|numeric|callback_check_total_installment_non_zero');
		$this->form_validation->set_rules('is_loan_applicable', '', 'callback_is_loan_applicable');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no'),
				'date' => form_error('date'),
				'loan_amount' => form_error('loan_amount'),
				'service_charge' => form_error('service_charge'),
				'total_installment' => form_error('total_installment'),
				'is_loan_applicable' => form_error('is_loan_applicable'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_loan->add_loan();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function edit_loan_infromation(){
		if(!common::page_permission("loan","editLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('loan_amount', 'Loan Amount', 'required|trim|xss_clean|numeric|callback_check_loan_amount_non_zero');
		$this->form_validation->set_rules('service_charge', 'Service Charge', 'required|trim|xss_clean|numeric|callback_check_service_charge_non_zero');
		$this->form_validation->set_rules('total_installment', 'No of installment', 'required|trim|xss_clean|numeric|callback_check_total_installment_non_zero');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date'),
				'loan_amount' => form_error('loan_amount'),
				'service_charge' => form_error('service_charge'),
				'total_installment' => form_error('total_installment'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
		//	$id=$this->mod_loan->edit_loan();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				 $this->session->set_flashdata("success_msg","Record updated Successfully");
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	 function valid_member_id() {
        $member_no = $_POST['member_no'];
        if ($_REQUEST['id']) {
            $con.=" and member_id<>'{$_REQUEST['id']}'";
        }
        if (!sql::count('members', "member_no='$member_no' $con") > 0) {
            $this->form_validation->set_message('valid_member_id', 'Invalid Member ID');
            return FALSE;
        } else {
            return TRUE;
        }
    }
	function is_loan_applicable(){
		$member_id = $_POST['member_id'];
		$row=sql::row("loan","member_id='{$member_id}' and center_id='{$_REQUEST['center_id']}' and status=1");
		if(count($row)>0){
			$this->form_validation->set_message('is_loan_applicable', 'You are not allowed to this loan');
            return FALSE;
		}
		 else {
            return TRUE;
        }
	}
	
	function check_loan_amount_non_zero(){
		if ($_REQUEST['loan_amount']==0) {
            $this->form_validation->set_message('check_loan_amount_non_zero', 'The loan amount  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function check_service_charge_non_zero(){
		if ($_REQUEST['service_charge']==0) {
            $this->form_validation->set_message('check_service_charge_non_zero', 'The service charge  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function check_total_installment_non_zero(){
		if ($_REQUEST['total_installment']==0) {
            $this->form_validation->set_message('check_total_installment_non_zero', 'The number of installment  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function show_loan(){
		$data=$this->mod_loan->get_loan_data($_REQUEST['id']);
		$data['dir'] = $this->dir;
		$data['page']="loan_details";
		$this->load->view('main_ajax_content',$data);
	}
}
?>