<?php

class loan extends CI_Controller {

    private $dir = 'loan';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_loan');
        common::is_logged();
		common::getExecuteQuery();
    }
	function index() {
		if(!common::page_permission("loan","viewLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_loan->get_loan_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('loan/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_loan->get_loan_list($limit = true, $start, $config['per_page']);
        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Loan Information";
        $data['page_title'] = 'Loan Information';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	function loan_entry() {
		 if(!common::page_permission("loan","addLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data=common::get_settings_data();
        $data['header_title'] = "Loan Entry";
        $data['page_title'] = 'Loan Entry';
		$data['dir']=$this->dir;
        $data['page'] = 'new_loan';
        $this->load->view('main', $data);
    }
	function edit_loan() {
		if(!common::page_permission("loan","editLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$id=$_REQUEST['id'];
		$data=common::get_settings_data();
		$data=$this->mod_loan->get_loan_data($id);
        $data['header_title'] = "Loan Edit";
        $data['page_title'] = 'Loan Edit';
		$data['dir']=$this->dir;
        $data['page'] = 'edit_loan';
        $this->load->view('main', $data);
    }
	function save_loan(){
		if(!common::page_permission("loan","addLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_valid_member_id');
		$this->form_validation->set_rules('req_id', 'Requisition No', 'required|callback_check_valid_req_no');
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('loan_amount', 'Loan Amount', 'required|trim|xss_clean|numeric|callback_check_loan_amount_non_zero');
		$this->form_validation->set_rules('service_charge', 'Service Charge', 'required|trim|xss_clean|numeric|callback_check_service_charge_non_zero');
		$this->form_validation->set_rules('total_installment', 'No of installment', 'required|trim|xss_clean|numeric|callback_check_total_installment_non_zero');
		$this->form_validation->set_rules('is_loan_applicable', '', 'callback_is_loan_applicable');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no'),
				'date' => form_error('date'),
				'req_id' => form_error('req_id'),
				'loan_amount' => form_error('loan_amount'),
				'service_charge' => form_error('service_charge'),
				'total_installment' => form_error('total_installment'),
				'is_loan_applicable' => form_error('is_loan_applicable'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_loan->add_loan();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function check_valid_req_no(){
		$row=sql::row("loan_requision","loan_requision.status=1 AND loan_requision.is_loan_issue=0 and member_id='{$_REQUEST['member_id']}'");
		if($row['req_id']){
			return true;
		}
		else{
			 $this->form_validation->set_message('check_valid_req_no', 'Invalid requisition data');
            return FALSE;
		}
	}
	function edit_loan_infromation(){
		if(!common::page_permission("loan","editLoan")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('loan_amount', 'Loan Amount', 'required|trim|xss_clean|numeric|callback_check_loan_amount_non_zero');
		$this->form_validation->set_rules('service_charge', 'Service Charge', 'required|trim|xss_clean|numeric|callback_check_service_charge_non_zero');
		$this->form_validation->set_rules('total_installment', 'No of installment', 'required|trim|xss_clean|numeric|callback_check_total_installment_non_zero');
		if ($this->form_validation->run() == false) {
            $data = array(
				'date' => form_error('date'),
				'loan_amount' => form_error('loan_amount'),
				'service_charge' => form_error('service_charge'),
				'total_installment' => form_error('total_installment'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
		//	$id=$this->mod_loan->edit_loan();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				 $this->session->set_flashdata("success_msg","Record updated Successfully");
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function check_valid_member_id() {
        $member_no = $_POST['member_no'];
		$member_id = $_POST['member_id'];
        if ($_REQUEST['id']) {
            $con.=" and member_id<>'{$_REQUEST['id']}'";
        }
		$member=sql::row('members', "member_no='$member_no' and member_id='{$member_id}' and is_black=0 and is_death=0 $con");
        if ($member['member_id']=="") {
            $this->form_validation->set_message('check_valid_member_id', 'Invalid Member ID');
            return FALSE;
        }
		else {
            return TRUE;
        }
    }
	 function valid_member_id() {
        $member_no = $_POST['member_no'];
		$member_id = $_POST['member_id'];
        if ($_REQUEST['id']) {
            $con.=" and member_id<>'{$_REQUEST['id']}'";
        }
		$member=sql::row('members', "member_no='$member_no' and member_id='{$member_id}'  $con");
        if ($member['member_id']=="") {
            $this->form_validation->set_message('valid_member_id', 'Invalid Member ID');
            return FALSE;
        }
		else {
            return TRUE;
        }
    }
	function is_loan_applicable(){
		$member_id = $_POST['member_id'];
		$row=sql::row("loan","member_id='{$member_id}' and center_id='{$_REQUEST['center_id']}' and status=1");
		if(count($row)>0){
			$this->form_validation->set_message('is_loan_applicable', 'You are not allowed to this loan');
            return FALSE;
		}
		 else {
            return TRUE;
        }
	}
	
	function check_loan_amount_non_zero(){
		if ($_REQUEST['loan_amount']==0) {
            $this->form_validation->set_message('check_loan_amount_non_zero', 'The loan amount  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function check_service_charge_non_zero(){
		if ($_REQUEST['service_charge']==0) {
            $this->form_validation->set_message('check_service_charge_non_zero', 'The service charge  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function check_total_installment_non_zero(){
		if ($_REQUEST['total_installment']==0) {
            $this->form_validation->set_message('check_total_installment_non_zero', 'The number of installment  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function show_loan(){
		$data=$this->mod_loan->get_loan_data($_REQUEST['id']);
		$data['dir'] = $this->dir;
		$data['page']="loan_details";
		$this->load->view('main_ajax_content',$data);
	}
	/**new requisition**/
	function new_requisition() {
		 if(!common::page_permission("loan","addLoanRequisition")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data=common::get_settings_data();
        $data['header_title'] = "Loan Requisition";
        $data['page_title'] = 'Loan Requisition';
		$data['dir']=$this->dir;
        $data['page'] = 'new_requisition';
        $this->load->view('main', $data);
    }
	/**save requisition**/
	function save_requisition(){
		if(!common::page_permission("loan","addLoanRequisition")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('member_no', 'Member ID', 'required|trim|xss_clean|callback_check_valid_member_id');
		$this->form_validation->set_rules('loan_type', 'Loan Type', 'required');
		$this->form_validation->set_rules('time_period', 'Time Length', 'required');
		$this->form_validation->set_rules('total_installment', 'No of Installment', 'required');
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('loan_amount', 'Loan Amount', 'required|trim|xss_clean|numeric|callback_check_loan_amount_non_zero');
		$this->form_validation->set_rules('is_requisition_applicable', '', 'callback_is_requisition_applicable');
		$this->form_validation->set_rules('service_charge','Service Charge', 'required');
		if ($this->form_validation->run() == false) {
            $data = array(
                'member_no' => form_error('member_no'),
				'date' => form_error('date'),
				'loan_type' => form_error('loan_type'),
				'total_installment' => form_error('total_installment'),
				'service_charge' => form_error('service_charge'),
				'loan_amount' => form_error('loan_amount'),
				'is_requisition_applicable' => form_error('is_requisition_applicable'),
				'time_period' => form_error('time_period')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_loan->add_requisition();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function is_requisition_applicable(){
		$member_id = $_POST['member_id'];
		$row=sql::row("loan_requision","member_id='{$member_id}'  and is_loan_issue=0");
        $loan=sql::row("loan","member_id='{$member_id}'  and status=1");
		if(count($row)>0){
			$this->form_validation->set_message('is_requisition_applicable', 'You are not allowed to sent the requsition for this member as he has one requisition');
            return FALSE;
		}
		elseif (count($loan)>0){
            $this->form_validation->set_message('is_requisition_applicable', 'You are not allowed to sent the requsition for this member as he has already active loan');
            return FALSE;
        }
		 else {
            return TRUE;
        }
	}
    function requisition_pending(){
        if(!common::page_permission("loan","viewPendingRequisition")){
            $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
            common::redirect();
        }
        $data['loan'] = $this->mod_loan->get_requisition_list();
        $data['dir']="loan";
        $data['header_title'] = "Pending Requisition";
        $data['page_title'] = 'Pending Requisition';
        $data['page'] = 'requsition_pending';
        $this->load->view('main', $data);
    }
	/**Pending Approve**/
	function requisition_approve(){
		if(!common::page_permission("loan","viewApproveRequisition")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['loan'] = $this->mod_loan->get_requisition_list(1);
		$data['dir']="loan";
        $data['header_title'] = "Approve Requisition";
        $data['page_title'] = 'Approve Requisition';
        $data['page'] = 'requsition_approve';
        $this->load->view('main', $data);
	}
	function requisition_cancel(){
		if(!common::page_permission("loan","viewCancelRequisition")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['loan'] = $this->mod_loan->get_requisition_list(2);
		$data['dir']="loan";
        $data['header_title'] = "Cancel Requisition";
        $data['page_title'] = 'Cancel Requisition';
        $data['page'] = 'requsition_cancel';
        $this->load->view('main', $data);
	}
	function approve(){
		if(!common::page_permission("loan","approveRequisition")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('req_id', 'Requisition', 'required|callback_check_valid_req');
		$this->form_validation->set_rules('approve_amount', 'Approve Amount', 'required|trim|xss_clean|numeric|callback_check_approve_amount_non_zero');
		
		if ($this->form_validation->run() == false) {
            $data = array(
				'req_id' => form_error('req_id'),
				'approve_amount' => form_error('approve_amount')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_loan->approve_requisition();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Requisition Approved SUccessfully');
				
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function reject(){
		if(!common::page_permission("loan","rejectRequisition")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('req_id', 'Requisition', 'required|callback_check_valid_req');
		if ($this->form_validation->run() == false) {
            $data = array(
				'req_id' => form_error('req_id')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_loan->reject_requisition();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Requisition Rejected Successfully');
				
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function change_approve_amount(){
		if(!common::page_permission("loan","updateApproveAmount")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('req_id', 'Requisition', 'required|callback_check_valid_req_approve');
		$this->form_validation->set_rules('approve_amount', 'Approve Amount', 'required|trim|xss_clean|numeric|callback_check_valid_approve_amount');
		
		if ($this->form_validation->run() == false) {
            $data = array(
				'req_id' => form_error('req_id'),
				'approve_amount' => form_error('approve_amount')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_loan->change_approve_amount();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'The amount has been changed Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Nothing to change'));
				echo json_encode($array);
			}
		}
	}
	function check_valid_req(){
		if(!sql::count("loan_requision","req_id='{$_REQUEST['req_id']}' and status=0 and is_loan_issue=0")){
			$this->form_validation->set_message('check_valid_req', 'Invalid Requisition you are approving');
			return false;
		}
		 return TRUE;
	}
	function check_valid_req_approve(){
		if(!sql::count("loan_requision","req_id='{$_REQUEST['req_id']}' and status=1 and is_loan_issue=0")){
			$this->form_validation->set_message('check_valid_req', 'Invalid Requisition you are approving');
			return false;
		}
		 return TRUE;
	}
    function check_valid_approve_amount(){
        $loan_req=sql::row("loan_requision","req_id='{$_REQUEST['req_id']}'","approve_amount");
        if ($_REQUEST['approve_amount']==0) {
            $this->form_validation->set_message('check_valid_approve_amount', 'The Approve amount  field contains a number which is geater than zero');
            return FALSE;
        }
        elseif($loan_req['approve_amount']==$_REQUEST['approve_amount']){
            $this->form_validation->set_message('check_valid_approve_amount', 'Nothing to change');
            return FALSE;
        }
        else {
            return TRUE;
        }
    }
    function search_loan_data(){
        $data['branch_list']=common::get_branch_list();
        $data['center_list']=common::get_center_list();
        $data['id']=$this->id;
        $data['dir'] = $this->dir;
        $data['header_title'] = "Member Information";
        $data['page_title'] = 'Member Information';
        $data['page'] = 'search_id_card';
        $this->load->view('main_ajax_content', $data);
    }
    function get_member_loan_data(){
        $data['center_name']=common::center_list_array();
        $data['center_no']=common::center_list_array('id');
        $data['branch_name']=common::branch_list_array();
        $data['member']=$this->mod_loan->get_member_loan_data();
       // common::pr( $data['member']);
        $data['dir'] = $this->dir;
        $data['page'] = 'show_member_list';
        $this->load->view('main_ajax_content', $data);

      //  echo json_encode($query->row_array());
    }
}
?>