<?php

class expense extends CI_Controller {

    private $dir = 'expense';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_expense');
        common::is_logged();
		common::getExecuteQuery();
    }
	function index() {
		 if(!common::page_permission("expense","viewExpense")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_expense->get_expense_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('expense/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_expense->get_expense_list($limit = true, $start, $config['per_page']);
        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Expense History";
        $data['page_title'] = 'Expense History';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	 function expense_head() {
		 if(!common::page_permission("expense","viewExpenseHead")&&!common::page_permission("expense","addExpenseHead")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$id=$_REQUEST['id'];
		if ($_POST['save']) {
				if($id){
					$this->mod_expense->update_head($id);
					$this->session->set_flashdata('msg', 'Head was Updated Successfully!!!');
					redirect('?c=expense&m=expense_head');
				}
				else{
					if ($this->mod_expense->save_head()) {
						$this->session->set_flashdata('msg', 'Head was Added Successfully!!!');
						redirect('?c=expense&m=expense_head');
					}
				}
			
		}
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_expense->get_expense_head_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('expense/expense_head');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_expense->get_expense_head_list($limit = true, $start, $config['per_page']);
        $data['msg'] = $this->session->flashdata('msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
	
		$data['users']=sql::row("expense_head","id='{$id}'");
		$data['zone_list']=common::get_zone_list($data['users']['zone_id']);
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Expense Head Settings";
        $data['page_title'] = 'Expense Head Settings';
        $data['page'] = 'expense_head';
        $this->load->view('main', $data);
    }
	
	
	function delete_head() {
		 if(!common::page_permission("expense","deleteExpenseHead")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $uid = $_REQUEST['id'];
        
        if ($uid == '') {
            redirect("?c=expense&m=expense_head");
        }
        $this->db->query("update  expense_head set status=2 where id='$uid'");
        $this->session->set_flashdata("msg", "Row Deleted Successfully");
        redirect("?c=expense&m=expense_head");
    }
	function expense_entry() {
		 if(!common::page_permission("expense","addExpense")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $data['header_title'] = "Expense Entry";
        $data['page_title'] = 'Expense Entry';
		$data['dir']=$this->dir;
        $data['page'] = 'expense_entry';
        $this->load->view('main', $data);
    }
	function save_expense(){
		 if(!common::page_permission("expense","addExpense")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('branch_id', 'Branch', 'required');
		$this->form_validation->set_rules('head_id', 'Expense Head', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|xss_clean|numeric|callback_check_amount_non_zero');
		if ($this->form_validation->run() == false) {
            $data = array(
				'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'date' => form_error('date'),
				'head_id' => form_error('head_id'),
				'amount' => form_error('amount')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_expense->save_expense();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function delete_expense($id) {
		 if(!common::page_permission("expense","deleteExpense")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $uid =$id;
		//echo $uid;exit;
        if (!common::is_admin_logged()) {
            $this->session->set_flashdata("success_msg", "Unathorized User");
             redirect("?c=expense&m=index");
        }
        if ($uid == '') {
            redirect("?c=expense&m=index");
        }
        $this->db->query("delete from expense where id='$uid'");
		 $this->db->query("delete from balance where expense_id='$uid'");
        $this->session->set_flashdata("success_msg", "Row Deleted Successfully");
        redirect("?c=expense&m=index");
    }
}
?>