<?php

class company_account extends CI_Controller {

    private $dir = 'company_account';

    function __construct() {
        parent::__construct();
        $this->load->model('mod_company_account');
        common::is_logged();
		common::getExecuteQuery();
    }
	function index() {
		if(!common::page_permission("fund_transfer","viewFundTransfer")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $this->load->library("pagination");
        $start = $this->uri->segment(3);
        if ($start == '') {
            $start = 0;
        }
        $total_rows1 = count($this->mod_company_account->get_account_list());
        $config['uri_segment'] = 3;
        $config['base_url'] = site_url('saving_account/index');
        $config['total_rows'] = $total_rows1;
        $config['per_page'] = 50;
        $config['next_link'] = "Next &raquo;";
        $config['prev_link'] = "&laquo; Previous";
        $this->pagination->initialize($config);
        $data['pagination_links'] = $this->pagination->create_links();
        $data['prev_next'] = $this->pagination->create_links();
        $data['user'] = $this->mod_company_account->get_account_list($limit = true, $start, $config['per_page']);
        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['dir'] = $this->dir;
		if($total_rows1>0){
		$data['pagermessage'] = 'Records <b>'.($this->pagination->cur_page==0?1:(($this->pagination->cur_page-1)*$this->pagination->per_page)+1).'</b> to <b>'.($this->pagination->cur_page==0?1*$total_rows1:$start+count($data['user'])).'</b> of <b>'.$total_rows1.'</b>';
		}
		else{
			$data['pagermessage']="No record found";
		}
		
		$data['total_rows'] = $total_rows1;
        $data['header_title'] = "Company Transaction";
        $data['page_title'] = 'Company Transaction';
        $data['page'] = 'index';
        $this->load->view('main', $data);
    }
	
	
	function check_amount_non_zero(){
		if ($_REQUEST['amount']==0) {
            $this->form_validation->set_message('check_amount_non_zero', 'The  amount  field contains a number which is geater than zero');
            return FALSE;
        } else {
            return TRUE;
        }
	}
	function credit() {
		if(!common::page_permission("fund_transfer","creditFundTransfer")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['upload']=true;
        $data['header_title'] = "Withdraw";
        $data['page_title'] = 'Withdraw';
		$data['dir']=$this->dir;
        $data['page'] = 'credit';
        $this->load->view('main', $data);
    }
	
	function debit() {
		if(!common::page_permission("fund_transfer","debitFundTransfer")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
        $data['header_title'] = "Deposit";
        $data['page_title'] = 'Deposit';
		$data['dir']=$this->dir;
        $data['page'] = 'debit';
        $this->load->view('main', $data);
    }
	function save_debit(){
		if(!common::page_permission("fund_transfer","debitundTransfer")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('branch_id', 'Branch', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|xss_clean|numeric|callback_check_amount_non_zero');
		if ($this->form_validation->run() == false) {
            $data = array(
				'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'date' => form_error('date'),
				'amount' => form_error('amount')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_company_account->save_debit_data();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function save_credit(){
		if(!common::page_permission("fund_transfer","creditFundTransfer")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$this->form_validation->set_rules('date', 'Date', 'required|trim|xss_clean');
		$this->form_validation->set_rules('zone_id', 'Zone', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('branch_id', 'Branch', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|xss_clean|numeric|callback_check_amount_non_zero');
		if ($this->form_validation->run() == false) {
            $data = array(
				'zone_id' => form_error('zone_id'),
				'area_id' => form_error('area_id'),
				'branch_id' => form_error('branch_id'),
				'date' => form_error('date'),
				'amount' => form_error('amount')
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        }
		else{
			$id=$this->mod_company_account->save_credit_data();
			if($id){
				 $array = array('status' => 'success', 'error' => '', 'message' => 'Record Saved Successfully');
				echo json_encode($array);
			}
			else{
				$array = array('status' => 'fail', 'error' => array('test'=>'Something was wrong'));
				echo json_encode($array);
			}
		}
	}
	function delete_transaction($id) {
		
		if(!common::page_permission("fund_transfer","deleteFundTransfer")){
			//echo "here";exit;
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		//exit;
        $uid = $id;
        if ($uid == '') {
            redirect("?c=company_account");
        }
		$row=sql::row("company_account_transaction","transaction_id='{$uid}'");
		
        $this->db->query("delete from company_account_transaction where transaction_id='{$id}'");
		 $this->db->query("delete from balance where company_transaction_id='{$id}'");
        $this->session->set_flashdata("success_msg", "Row Deleted Successfully");
        redirect("?c=company_account");
    }
	
}
?>