<?php
class cash_register extends CI_Controller {
    private $dir = 'cash_register';
    function __construct() {
        parent::__construct();
        common::is_logged();
		$this->load->model("mod_cash_register");
		$this->load->model("mod_member");
		common::getExecuteQuery();
    }
	function loan_register(){
		if(!common::page_permission("cashRegister","postLoanRegister")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['date']=date("Y-m-d");
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Loan Register";
        $data['page_title'] = 'Loan Register';
        $data['page'] = 'loan_register';
        $this->load->view('main', $data);
	}
	function saving_register(){
		if(!common::page_permission("cashRegister","postSavingRegister")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['date']=date("Y-m-d");
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "Saving Register";
        $data['page_title'] = 'Saving Register';
        $data['page'] = 'saving_register';
        $this->load->view('main', $data);
	}
	function dps_register(){
		if(!common::page_permission("cashRegister","postDpsRegister")){
			 $this->session->set_flashdata("warning_msg","You are not allowed to access this page");
			 common::redirect();
		 }
		$data['date']=date("Y-m-d");
		$data['dir'] = $this->dir;
		$data['total_rows'] = $total_rows;
        $data['header_title'] = "DPS Register";
        $data['page_title'] = 'DPS Register';
        $data['page'] = 'dps_register';
        $this->load->view('main', $data);
	}
	 function load_branch()
    {
        global $global_config, $sesGroupId, $sesEmployerId;
		$con="";
		if(!common::is_super()){
			$con.=" and branch_id in('".$this->session->userdata("branch_id")."')";
		}
	
        list ($START_PAGE, $PERPAGE_COUNT) = common::getPosStartAndCountPerPage();
			$query=$this->db->query("select * from branch where 1 $con ORDER BY branch_name asc");
			$QryResult=$query->result_array();
            $TotalRec = $query->num_rows();
			ob_clean();
			header("Content-type:text/xml");
			$strXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        
			$strXml .= "<rows total_count=\"" . $TotalRec . "\" pos=\"" . $START_PAGE . "\">\n";
        if (!empty($TotalRec)) {
            for ($i = 0; $i < $TotalRec; $i++) {
                #$rowStatus = 1; 
               
                $strXml .= "<row id=\"" . $QryResult [$i]['branch_id'] . "\">\n";
                $strXml .= "<cell><![CDATA[" . $rowStatus . "]]></cell>\n";
                $strXml .= "<cell><![CDATA[" . $QryResult[$i]['branch_name'] . "]]></cell>\n";
                $strXml .= "<userdata name=\"Used_Years\">" . $QryResult[$i]['TAX_RETURN_YEAR_ID'] . "</userdata>\n";
                $strXml .= "<userdata name=\"editStatus\">" . $editStatus . "</userdata>\n";
                $strXml .= "<userdata name=\"rowStatus\">" . $rowStatus . "</userdata>\n";
                #$strXml .= "<userdata name=\"HEADER_IDENT\">" . $objArray['HEADER_IDENT']  . "</userdata>\n";
                #$strXml .= "<userdata name=\"TAX_RETURN_YEAR_ID\">" .$QryResult[$i]['TAX_RETURN_YEAR_ID']  . "</userdata>\n";
         
                $strXml .= "</row>";  
            }
            
        } else {
            $strXml .= "<row id=\"0\">\n";
            $strXml .= "<cell colspan=\"1\" align=\"center\"><![CDATA[<b>No Records Found</b>]]></cell>\n";
            $strXml .= "</row>";
        }
        $strXml .= "</rows>";

        print $strXml;
        exit ();
    } 
	function load_center(){
		global $global_config, $sesGroupId, $sesEmployerId;
		
        list ($START_PAGE, $PERPAGE_COUNT) = common::getPosStartAndCountPerPage();
		$whr="where  1 ";
		
		if($_REQUEST['branch_id'])
			//implode("','",explode(",",$_REQUEST['member_no']))
			$whr.=" and branch_id in('".implode("','",explode(",",$_REQUEST['branch_id']))."')";
			if(!common::is_super()&&$this->session->userdata("center_id")!=""){
			$whr.=" and center_id in(".$this->session->userdata("center_id").")";
		}
		
			$query=$this->db->query("select * from center $whr ORDER BY center_name asc");
			$QryResult=$query->result_array();
            $TotalRec = $query->num_rows();
			ob_clean();
			header("Content-type:text/xml");
			$strXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        
			$strXml .= "<rows total_count=\"" . $TotalRec . "\" pos=\"" . $START_PAGE . "\">\n";
        if (!empty($TotalRec)) {
            for ($i = 0; $i < $TotalRec; $i++) {
                #$rowStatus = 1; 
               
                $strXml .= "<row id=\"" . $QryResult [$i]['center_id'] . "\">\n";
                $strXml .= "<cell><![CDATA[" . $rowStatus . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['center_no'] . "]]></cell>\n";
                $strXml .= "<cell><![CDATA[" . $QryResult[$i]['center_name'] . "]]></cell>\n";
                $strXml .= "<userdata name=\"Used_Years\">" . $QryResult[$i]['TAX_RETURN_YEAR_ID'] . "</userdata>\n";
                $strXml .= "<userdata name=\"editStatus\">" . $editStatus . "</userdata>\n";
                $strXml .= "<userdata name=\"rowStatus\">" . $rowStatus . "</userdata>\n";
                $strXml .= "</row>";  
            }
            
        } else {
            $strXml .= "<row id=\"0\">\n";
            $strXml .= "<cell colspan=\"1\" align=\"center\"><![CDATA[<b>No Records Found</b>]]></cell>\n";
            $strXml .= "</row>";
        }
        $strXml .= "</rows>";

        print $strXml;
        exit ();
	}
	function load_loan_cash(){
		//print_r($_REQUEST);exit;
		global $global_config, $sesGroupId, $sesEmployerId;
		$PERPAGE_COUNT=100;
		$date=date("Y-m-d");
		$date=$_REQUEST['date'];
        list ($START_PAGE, $PERPAGE_COUNT) = common::getPosStartAndCountPerPage();
		$cond=" where 1 and b.date='{$date}'";
		/*if($_REQUEST['branch'])
			$cond.=" and b.branch_id in ({$_REQUEST['branch']})";
		if($_REQUEST['center'])
			$cond.=" and b.center_id in ({$_REQUEST['center']})";*/
		if ($_REQUEST['branch']) 
		{
			$cond.=" and b.branch_id  in('".implode("','",explode(",",$_REQUEST['branch']))."')";
			// $cond.="and b.branch_id in ({$_REQUEST['branch']})";
		}
		else{
			if(!common::is_super()&&$this->session->userdata("branch_id")!=""){
				$cond.=" and b.branch_id in('".$this->session->userdata("branch_id")."')";
			}
		}
		
		if ($_REQUEST['center']) {
			$cond.=" and b.center_id  in('".implode("','",explode(",",$_REQUEST['center']))."')";
			//$cond.=" and b.center_id in ({$_REQUEST['center']})";
		}
		else{
			if(!common::is_super()&&$this->session->userdata("center_id")!=""){
				$cond.=" and b.center_id in(".$this->session->userdata("center_id").")";
			}
		}
			$query=$this->db->query("select b.date,b.center_id,b.zone_id,b.area_id,b.branch_id,branch.branch_name,center.center_name,center.center_no,sum(ltd.amount) as loan_transaction_amount_daily,sum(ltw.amount) as loan_transaction_amount_weekly,sum(ltm.amount) as loan_transaction_amount_monthly, count(lt.member_id) as transaction_beneficiary, sum(ld.loan_amount) as loan_amount_daily,sum(lw.loan_amount) as loan_amount_weekly,sum(lm.loan_amount) as loan_amount_monthly,
			SUM(ld.service_charge_amount) AS daily_service_charge,
SUM(lw.service_charge_amount) AS weekly_service_charge,
SUM(lm.service_charge_amount) AS monthly_service_charge,

			count(ld.member_id) as beneficiary_daily,
			count(lw.member_id) as beneficiary_weekly,
			count(lm.member_id) as beneficiary_monthly
			from balance b 
			left join loan_transaction as lt on (lt.transaction_id=b.loan_transaction_id)
			left join loan_transaction as ltd on (ltd.transaction_id=b.loan_transaction_id and ltd.account_type=1)
			left join loan_transaction as ltw on (ltw.transaction_id=b.loan_transaction_id and ltw.account_type=2)
			left join loan_transaction as ltm on (ltm.transaction_id=b.loan_transaction_id and ltm.account_type=3)
			left join loan as ld on (ld.loan_id=b.loan_id and ld.loan_type=1)
			left join loan as lw on (lw.loan_id=b.loan_id and lw.loan_type=2)
			left join loan as lm on (lm.loan_id=b.loan_id and lm.loan_type=3)
			left join branch on branch.branch_id=b.branch_id
			left join center on center.center_id=b.center_id  $cond
			group by b.date,b.branch_id,b.center_id   
			having (
			loan_amount_daily is not null
			or loan_amount_weekly is not null
			or loan_amount_monthly is not null
			or loan_transaction_amount_daily is not null
			or loan_transaction_amount_weekly is not null
			or loan_transaction_amount_monthly is not null
			) order by b.date desc");
			
		$QryResult=$query->result_array();
		$TotalRec = $query->num_rows();
		ob_clean();
		header("Content-type:text/xml");
		$strXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
		$strXml .= "<rows total_count=\"" . $TotalRec . "\" pos=\"" . $START_PAGE . "\">\n";
		 if (!empty($TotalRec)) {
            for ($i = 0; $i < $TotalRec; $i++) {
                #$rowStatus = 1; 
				$status="";
				$row=sql::row("loan_cash_register","date='{$date}' and center_id='".$QryResult[$i]['center_id']."' and branch_id='".$QryResult[$i]['branch_id']."' and zone_id='".$QryResult[$i]['zone_id']."' and area_id='".$QryResult[$i]['area_id']."'");
				if(count($row)>0)
					$QryResult[$i]["DISABLED"] = 1;
				else{
					$QryResult[$i]["DISABLED"] = 0;
				}
				if(count($row)>0 && $row['status']==0)
					$status="Posted";
				if($QryResult[$i]['loan_transaction_amount_daily']=="")
					$QryResult[$i]['loan_transaction_amount_daily']=0;
				if($QryResult[$i]['loan_transaction_amount_weekly']=="")
					$QryResult[$i]['loan_transaction_amount_weekly']=0;
				if($QryResult[$i]['loan_transaction_amount_monthly']=="")
					$QryResult[$i]['loan_transaction_amount_monthly']=0;
				
				
				if($QryResult[$i]['beneficiary_daily']=="")
					$QryResult[$i]['beneficiary_daily']=0;
				if($QryResult[$i]['beneficiary_weekly']=="")
					$QryResult[$i]['beneficiary_weekly']=0;
				if($QryResult[$i]['beneficiary_monthly']=="")
					$QryResult[$i]['beneficiary_monthly']=0;
				if($QryResult[$i]['loan_amount_daily']=="")
					$QryResult[$i]['loan_amount_daily']=0;
				if($QryResult[$i]['loan_amount_weekly']=="")
					$QryResult[$i]['loan_amount_weekly']=0;
				if($QryResult[$i]['loan_amount_monthly']=="")
					$QryResult[$i]['loan_amount_monthly']=0;
				//service Charge
				if($QryResult[$i]['daily_service_charge']=="")
					$QryResult[$i]['daily_service_charge']=0;
				if($QryResult[$i]['weekly_service_charge']=="")
					$QryResult[$i]['weekly_service_charge']=0;
				if($QryResult[$i]['monthly_service_charge']=="")
					$QryResult[$i]['monthly_service_charge']=0;
				$QryResult[$i]['service_charge']=$QryResult[$i]['daily_service_charge']+$QryResult[$i]['weekly_service_charge']+$QryResult[$i]['monthly_service_charge'];
				//end
				if($QryResult[$i]['transaction_beneficiary']=="")
					$QryResult[$i]['transaction_beneficiary']=0;
				$QryResult[$i]['beneficiary']=$QryResult[$i]['beneficiary_daily']+$QryResult[$i]['beneficiary_weekly']+$QryResult[$i]['beneficiary_monthly'];
				$total_loan_amount=$QryResult[$i]['loan_amount_daily']+$QryResult[$i]['loan_amount_weekly']+$QryResult[$i]['loan_amount_monthly']+$QryResult[$i]['service_charge'];
				$total_transaction_amount=$QryResult[$i]['loan_transaction_amount_daily']+$QryResult[$i]['loan_transaction_amount_weekly']+$QryResult[$i]['loan_transaction_amount_monthly'];
                $strXml .= "<row id=\"" . $i . "\">\n";
				$strXml .= "\t\t<cell></cell>\n";
                $strXml .= "<cell><![CDATA[" .  $QryResult [$i]['branch_name'] . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['center_no'] . "(".$QryResult[$i]['center_name'].")]]></cell>\n";
                $strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['loan_amount_daily'],2,'.',',') . "]]></cell>\n";
				 $strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['loan_amount_weekly'],2,'.',',') . "]]></cell>\n";
				 
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['loan_amount_monthly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['daily_service_charge'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['weekly_service_charge'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['monthly_service_charge'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[<b>" . number_format($total_loan_amount,2,'.',',') . "</b>]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . $QryResult[$i]['beneficiary'] . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['loan_transaction_amount_daily'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['loan_transaction_amount_weekly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[" . number_format($QryResult[$i]['loan_transaction_amount_monthly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell align='right'><![CDATA[<b>" . number_format($total_transaction_amount,2,'.',',') . "</b>]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['transaction_beneficiary'] . "]]></cell>\n";
				//$strXml .= "<cell ><![CDATA[" .  number_format($QryResult[$i]['loan_balance'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell ><![CDATA[" .  $status . "]]></cell>\n";
				$strXml .= "<userdata name=\"area_id\">" .  $QryResult[$i]['area_id'] . "</userdata>";
				$strXml .= "<userdata name=\"branch_id\">" .  $QryResult[$i]['branch_id'] . "</userdata>";
				$strXml .= "<userdata name=\"zone_id\">" .  $QryResult[$i]['zone_id'] . "</userdata>";
				$strXml .= "<userdata name=\"center_id\">" .  $QryResult[$i]['center_id'] . "</userdata>";
				$strXml .= "<userdata name=\"loan_amount_daily\">" .  $QryResult[$i]['loan_amount_daily'] . "</userdata>";
				$strXml .= "<userdata name=\"loan_amount_weekly\">" .  $QryResult[$i]['loan_amount_weekly'] . "</userdata>";
				$strXml .= "<userdata name=\"loan_amount_monthly\">" .  $QryResult[$i]['loan_amount_monthly'] . "</userdata>";
				$strXml .= "<userdata name=\"beneficiary\">" .  $QryResult[$i]['beneficiary'] . "</userdata>";
				$strXml .= "<userdata name=\"loan_transaction_amount_daily\">" .  $QryResult[$i]['loan_transaction_amount_daily'] . "</userdata>";
				$strXml .= "<userdata name=\"loan_transaction_amount_weekly\">" .  $QryResult[$i]['loan_transaction_amount_weekly'] . "</userdata>";
				$strXml .= "<userdata name=\"loan_transaction_amount_monthly\">" .  $QryResult[$i]['loan_transaction_amount_monthly'] . "</userdata>";
				$strXml .= "<userdata name=\"transaction_beneficiary\">" .  $QryResult[$i]['transaction_beneficiary'] . "</userdata>";
				$strXml .= "<userdata name=\"service_charge\">" .  $QryResult[$i]['service_charge'] . "</userdata>";
				$strXml .= "<userdata name=\"daily_service_charge\">" .  $QryResult[$i]['daily_service_charge'] . "</userdata>";
				$strXml .= "<userdata name=\"weekly_service_charge\">" .  $QryResult[$i]['weekly_service_charge'] . "</userdata>";
				$strXml .= "<userdata name=\"monthly_service_charge\">" .  $QryResult[$i]['monthly_service_charge'] . "</userdata>";
				//$strXml .= "<userdata name=\"loan_balance\">" .  $QryResult[$i]['loan_balance'] . "</userdata>";
				$strXml .= "<userdata name=\"DISABLED_FIELD\">" .  $QryResult[$i]['DISABLED'] . "</userdata>";
				
                $strXml .= "</row>";  
            }
            
        } else {
            $strXml .= "<row id=\"0\">\n";
            $strXml .= "<cell colspan=\"13\" type=\"ro\"  align=\"center\"><![CDATA[<b>No Records Found</b>]]></cell>\n";
            $strXml .= "</row>";
        }
        $strXml .= "</rows>";

        print $strXml;
        exit ();
	}
	function load_saving_cash(){
		
		global $global_config, $sesGroupId, $sesEmployerId;
		$PERPAGE_COUNT=100;
		$date=date("Y-m-d");
		$date=$_REQUEST['date'];
        list ($START_PAGE, $PERPAGE_COUNT) = common::getPosStartAndCountPerPage();
		$cond=" where 1 and b.date='{$date}'";
		/*if($_REQUEST['branch'])
			$cond.=" and b.branch_id in ({$_REQUEST['branch']})";
		if($_REQUEST['center'])
			$cond.=" and b.center_id in ({$_REQUEST['center']})";*/
		if ($_REQUEST['branch']) 
		{
			 $cond.="and b.branch_id='{$_REQUEST['branch']}'";
		}
		else{
			if(!common::is_super()&&$this->session->userdata("branch_id")!=""){
				$cond.=" and b.branch_id in('".$this->session->userdata("branch_id")."')";
			}
		}
		
		if ($_REQUEST['center']) {
			$cond.=" and b.center_id in ({$_REQUEST['center']})";
		}
		else{
			if(!common::is_super()&&$this->session->userdata("center_id")!=""){
				$cond.=" and b.center_id in(".$this->session->userdata("center_id").")";
			}
		}
			$query=$this->db->query("select b.date,b.center_id,b.zone_id,b.area_id,b.branch_id,branch.branch_name,center.center_name,center.center_no,sum(std.amount) as credit_amount_daily,
sum(stw.amount) as credit_amount_weekly,sum(stm.amount) as credit_amount_monthly, count(st.member_id) as credit_member, sum(stwd.amount) as debit_amount_daily,sum(stww.amount) as debit_amount_weekly,sum(stwm.amount) as debit_amount_monthly,count(st_withdraw.member_id) as debit_member,
sum(saving_interest_daily.amount) as saving_interest_daily,
sum(saving_interest_weekly.amount) as saving_interest_weekly,
sum(saving_interest_monthly.amount) as saving_interest_monthly
			from balance b 
			left join saving_account_transaction as std on (std.transaction_id=b.saving_transaction_id and std.transaction_type=1 and std.account_type=1)
			
			
			left join saving_account_transaction as stw on (stw.transaction_id=b.saving_transaction_id and stw.transaction_type=1 and stw.account_type=2)
			
			left join saving_account_transaction as stm on (stm.transaction_id=b.saving_transaction_id and stm.transaction_type=1 and stm.account_type=3)
			
			left join saving_account_transaction as st on (st.transaction_id=b.saving_transaction_id and st.transaction_type=1)
			
			left join saving_account_transaction as stwd on (stwd.transaction_id=b.saving_transaction_id and stwd.transaction_type=2 and stwd.account_type=1 )
			
			left join saving_account_transaction as stww on (stww.transaction_id=b.saving_transaction_id and stww.transaction_type=2 and stww.account_type=2 )
			
			left join saving_account_transaction as stwm on (stwm.transaction_id=b.saving_transaction_id and stwm.transaction_type=2 and stwm.account_type=3 )
			
			left join saving_account_transaction as st_withdraw on (st_withdraw.transaction_id=b.saving_transaction_id and st_withdraw.transaction_type=2  )
			
		
			
			left join saving_account as s on (s.account_id=b.saving_account_id)
			
				left join account_interest as saving_interest_daily on (saving_interest_daily.saving_account_transaction_id=b.saving_transaction_id  and saving_interest_daily.saving_account_id=s.account_id and s.account_type=1)
				
				left join account_interest as saving_interest_weekly on  (saving_interest_weekly.saving_account_transaction_id=b.saving_transaction_id  and saving_interest_weekly.saving_account_id=s.account_id and s.account_type=2)
				
				left join account_interest as saving_interest_monthly on  
				(saving_interest_monthly.saving_account_transaction_id=b.saving_transaction_id  and saving_interest_monthly.saving_account_id=s.account_id and s.account_type=3)
			left join branch on branch.branch_id=b.branch_id
			left join center on center.center_id=b.center_id   $cond
			group by b.date,b.branch_id,b.center_id 
			having (
			credit_amount_daily is not null
			or credit_amount_weekly is not null
			or credit_amount_monthly is not null
			or debit_amount_daily is not null
			or debit_amount_weekly is not null
			or debit_amount_monthly is not null
			)
			order by b.date desc");
			
		$QryResult=$query->result_array();
		$TotalRec = $query->num_rows();
		ob_clean();
		header("Content-type:text/xml");
		$strXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
		$strXml .= "<rows total_count=\"" . $TotalRec . "\" pos=\"" . $START_PAGE . "\">\n";
		 if (!empty($TotalRec)) {
            for ($i = 0; $i < $TotalRec; $i++) {
                #$rowStatus = 1; 
				$status="";
				$row=sql::row("saving_cash_register","date='{$date}' and center_id='".$QryResult[$i]['center_id']."' and branch_id='".$QryResult[$i]['branch_id']."' and zone_id='".$QryResult[$i]['zone_id']."' and area_id='".$QryResult[$i]['area_id']."'");
				if(count($row)>0)
					$QryResult[$i]["DISABLED"] = 1;
				else{
					$QryResult[$i]["DISABLED"] = 0;
				}
				if(count($row)>0 && $row['status']==0)
					$status="Posted";
				if($QryResult[$i]['credit_amount_daily']=="")
					$QryResult[$i]['credit_amount_daily']=0;
				if($QryResult[$i]['credit_amount_weekly']=="")
					$QryResult[$i]['credit_amount_weekly']=0;
				if($QryResult[$i]['credit_amount_monthly']=="")
					$QryResult[$i]['credit_amount_monthly']=0;
				
				$QryResult[$i]['total_credit']=$QryResult[$i]['credit_amount_daily']+$QryResult[$i]['credit_amount_weekly']+$QryResult[$i]['credit_amount_monthly'];
				
				if($QryResult[$i]['credit_member']=="")
					$QryResult[$i]['credit_member']=0;
				
				if($QryResult[$i]['debit_amount_daily']=="")
					$QryResult[$i]['debit_amount_daily']=0;
				if($QryResult[$i]['debit_amount_weekly']=="")
					$QryResult[$i]['debit_amount_weekly']=0;
				if($QryResult[$i]['debit_amount_monthly']=="")
					$QryResult[$i]['debit_amount_monthly']=0;
				
				$QryResult[$i]['total_debit']=$QryResult[$i]['debit_amount_daily']+$QryResult[$i]['debit_amount_weekly']+$QryResult[$i]['debit_amount_monthly'];
				
				if($QryResult[$i]['debit_member']=="")
					$QryResult[$i]['debit_member']=0;
				if($QryResult[$i]['saving_balance']=="")
					$QryResult[$i]['saving_balance']=0;
				
				
                $strXml .= "<row id=\"" . $i . "\">\n";
				$strXml .= "\t\t<cell></cell>\n";
                $strXml .= "<cell><![CDATA[" .  $QryResult [$i]['branch_name'] . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['center_no'] . "(".$QryResult[$i]['center_name'].")]]></cell>\n";
                $strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['credit_amount_daily'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['credit_amount_weekly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['credit_amount_monthly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['total_credit'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['credit_member'] . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['debit_amount_daily'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['debit_amount_weekly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['debit_amount_monthly'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['total_debit'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['debit_member'] . "]]></cell>\n";
				$strXml .= "<cell ><![CDATA[" .  number_format($QryResult[$i]['saving_balance'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell ><![CDATA[" .  $status . "]]></cell>\n";
				$strXml .= "<userdata name=\"area_id\">" .  $QryResult[$i]['area_id'] . "</userdata>";
				$strXml .= "<userdata name=\"branch_id\">" .  $QryResult[$i]['branch_id'] . "</userdata>";
				$strXml .= "<userdata name=\"zone_id\">" .  $QryResult[$i]['zone_id'] . "</userdata>";
				$strXml .= "<userdata name=\"center_id\">" .  $QryResult[$i]['center_id'] . "</userdata>";
				$strXml .= "<userdata name=\"credit_amount_daily\">" .  $QryResult[$i]['credit_amount_daily'] . "</userdata>";
				$strXml .= "<userdata name=\"credit_amount_weekly\">" .  $QryResult[$i]['credit_amount_weekly'] . "</userdata>";
				$strXml .= "<userdata name=\"credit_amount_monthly\">" .  $QryResult[$i]['credit_amount_monthly'] . "</userdata>";
				
				$strXml .= "<userdata name=\"credit_member\">" .  $QryResult[$i]['credit_member'] . "</userdata>";
				
				$strXml .= "<userdata name=\"debit_amount_daily\">" .  $QryResult[$i]['debit_amount_daily'] . "</userdata>";
				$strXml .= "<userdata name=\"debit_amount_weekly\">" .  $QryResult[$i]['debit_amount_weekly'] . "</userdata>";
				$strXml .= "<userdata name=\"debit_amount_monthly\">" .  $QryResult[$i]['debit_amount_monthly'] . "</userdata>";
				
				$strXml .= "<userdata name=\"debit_member\">" .  $QryResult[$i]['debit_member'] . "</userdata>";
				$strXml .= "<userdata name=\"saving_balance\">" .  $QryResult[$i]['saving_balance'] . "</userdata>";
				$strXml .= "<userdata name=\"DISABLED_FIELD\">" .  $QryResult[$i]['DISABLED'] . "</userdata>";
				
                $strXml .= "</row>";  
            }
            
        } else {
            $strXml .= "<row id=\"0\">\n";
            $strXml .= "<cell colspan=\"14\" type=\"ro\"  align=\"center\"><![CDATA[<b>No Records Found</b>]]></cell>\n";
            $strXml .= "</row>";
        }
        $strXml .= "</rows>";

        print $strXml;
        exit ();
	}
	function add_loan_register(){
		//print_r($_REQUEST);exit;
		$center=explode(",",$_REQUEST['selected_center_id']);
		$area=explode(",",$_REQUEST['selected_area_id']);
		$zone=explode(",",$_REQUEST['selected_zone_id']);
		$branch=explode(",",$_REQUEST['selected_branch_id']);
		$loan_amount_daily=explode(",",$_REQUEST['loan_amount_daily']);
		$loan_amount_weekly=explode(",",$_REQUEST['loan_amount_weekly']);
		$loan_amount_monthly=explode(",",$_REQUEST['loan_amount_monthly']);
		
		$daily_service_charge=explode(",",$_REQUEST['daily_service_charge']);
		$weekly_service_charge=explode(",",$_REQUEST['weekly_service_charge']);
		$monthly_service_charge=explode(",",$_REQUEST['monthly_service_charge']);
		
		$beneficiary=explode(",",$_REQUEST['beneficiary']);
		$loan_transaction_amount_daily=explode(",",$_REQUEST['loan_transaction_amount_daily']);
		$loan_transaction_amount_weekly=explode(",",$_REQUEST['loan_transaction_amount_weekly']);
		$loan_transaction_amount_monthly=explode(",",$_REQUEST['loan_transaction_amount_monthly']);
		
		$transaction_beneficiary=explode(",",$_REQUEST['transaction_beneficiary']);
		//$loan_balance=explode(",",$_REQUEST['loan_balance']);
		if(count($center)>0){
			for($i=0;$i<count($center);$i++){
				
				$data=array(
						'area_id'=>$area[$i],
						'zone_id'=>$zone[$i],
						'branch_id'=>$branch[$i],
						'center_id'=>$center[$i],
						'date'=>$_REQUEST['date'],
						'loan_amount_daily'=>$loan_amount_daily[$i],
						'loan_amount_weekly'=>$loan_amount_weekly[$i],
						'loan_amount_monthly'=>$loan_amount_monthly[$i],
						
						'daily_service_charge'=>$daily_service_charge[$i],
						'weekly_service_charge'=>$weekly_service_charge[$i],
						'monthly_service_charge'=>$monthly_service_charge[$i],
						'no_loan_member'=>$beneficiary[$i],
						'no_loan_member'=>$beneficiary[$i],
						'loan_collection_daily'=>$loan_transaction_amount_daily[$i],
						'loan_collection_weekly'=>$loan_transaction_amount_weekly[$i],
						'loan_collection_monthly'=>$loan_transaction_amount_monthly[$i],
						'no_collection_member'=>$transaction_beneficiary[$i],
						//'balance'=>$loan_balance[$i]
						);
						$this->db->insert("loan_cash_register",$data);
						$id[]=$this->db->insert_id();
			}
		}
		if(count($id)>0){
			$array = array('status' => 'success', 'error' => '', 'message' => 'Cash registre posted successfullt for date '.date("y/m/d",strtotime($_REQUEST['date'])));
			echo json_encode($array);
		}
		else{
			$array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
		}
	}
	function add_saving_register(){
		$date=date("Y-m-d");
		$date=$_REQUEST['date'];
		$cond=" where 1 ";
		$query=$this->db->query("select b.date,b.center_id,b.zone_id,b.area_id,b.branch_id,branch.branch_name,center.center_name,center.center_no,sum(std.amount) as credit_amount_daily,
sum(stw.amount) as credit_amount_weekly,sum(stm.amount) as credit_amount_monthly, count(st.member_id) as credit_member, sum(stwd.amount) as debit_amount_daily,sum(stww.amount) as debit_amount_weekly,sum(stwm.amount) as debit_amount_monthly,count(st_withdraw.member_id) as debit_member,
sum(saving_interest_daily.amount) as saving_interest_daily,
sum(saving_interest_weekly.amount) as saving_interest_weekly,
sum(saving_interest_monthly.amount) as saving_interest_monthly
			from balance b 
			left join saving_account_transaction as std on (std.transaction_id=b.saving_transaction_id and std.transaction_type=1 and std.account_type=1)
			
			
			left join saving_account_transaction as stw on (stw.transaction_id=b.saving_transaction_id and stw.transaction_type=1 and stw.account_type=2)
			
			left join saving_account_transaction as stm on (stm.transaction_id=b.saving_transaction_id and stm.transaction_type=1 and stm.account_type=3)
			
			left join saving_account_transaction as st on (st.transaction_id=b.saving_transaction_id and st.transaction_type=1)
			
			left join saving_account_transaction as stwd on (stwd.transaction_id=b.saving_transaction_id and stwd.transaction_type=2 and stwd.account_type=1 )
			
			left join saving_account_transaction as stww on (stww.transaction_id=b.saving_transaction_id and stww.transaction_type=2 and stww.account_type=2 )
			
			left join saving_account_transaction as stwm on (stwm.transaction_id=b.saving_transaction_id and stwm.transaction_type=2 and stwm.account_type=3 )
			
			left join saving_account_transaction as st_withdraw on (st_withdraw.transaction_id=b.saving_transaction_id and st_withdraw.transaction_type=2  )
			
		
			
			left join saving_account as s on (s.account_id=b.saving_account_id)
			
				left join account_interest as saving_interest_daily on (saving_interest_daily.saving_account_transaction_id=b.saving_transaction_id  and saving_interest_daily.saving_account_id=s.account_id and s.account_type=1)
				
				left join account_interest as saving_interest_weekly on  (saving_interest_weekly.saving_account_transaction_id=b.saving_transaction_id  and saving_interest_weekly.saving_account_id=s.account_id and s.account_type=2)
				
				left join account_interest as saving_interest_monthly on  
				(saving_interest_monthly.saving_account_transaction_id=b.saving_transaction_id  and saving_interest_monthly.saving_account_id=s.account_id and s.account_type=3)
			left join branch on branch.branch_id=b.branch_id
			left join center on center.center_id=b.center_id   where 1 
			group by b.date,b.branch_id,b.center_id 
			having (
			credit_amount_daily is not null
			or credit_amount_weekly is not null
			or credit_amount_monthly is not null
			or debit_amount_daily is not null
			or debit_amount_weekly is not null
			or debit_amount_monthly is not null
			or saving_interest_daily is not null
			or saving_interest_weekly is not null
			or saving_interest_monthly is not null
			)
			order by b.date desc");
			
			$rows=$query->result_array();
			//echo "<pre>";
		//	print_r($rows);exit;
			
			if(count($rows)>0){
				foreach($rows as $row){
					$date=$row['date'];
					$row_data=sql::row("saving_cash_register","date='{$date}' and center_id='".$row['center_id']."' and branch_id='".$row['branch_id']."' and zone_id='".$row['zone_id']."' and area_id='".$row['area_id']."'");
					$data=array(
						'area_id'=>$row['area_id'],
						'zone_id'=>$row['zone_id'],
						'branch_id'=>$row['branch_id'],
						'center_id'=>$row['center_id'],
						'date'=>$date,
						'credit_amount_daily'=>$row['credit_amount_daily'],
						'credit_amount_weekly'=>$row['credit_amount_weekly'],
						'credit_amount_monthly'=>$row['credit_amount_monthly'],
						'no_credit'=>$row['credit_member'],
						'debit_amount_daily'=>$row['debit_amount_daily'],
						'debit_amount_weekly'=>$row['debit_amount_weekly'],
						'debit_amount_monthly'=>$row['debit_amount_monthly'],
						'saving_interest_daily'=>$row['debit_amount_daily'],
						'saving_interest_weekly'=>$row['debit_amount_weekly'],
						'saving_interest_monthly'=>$row['debit_amount_monthly'],
						'no_debit'=>$row['debit_member'],
						//'balance'=>$saving_balance[$i]
						);
					//	print_r($data);exit;
						if(count($row_data)==0)
							$this->db->insert("saving_cash_register",$data);
					//	echo "<pre>";
						
				}
			}
			
		/*$center=explode(",",$_REQUEST['selected_center_id']);
		$area=explode(",",$_REQUEST['selected_area_id']);
		$zone=explode(",",$_REQUEST['selected_zone_id']);
		
		$branch=explode(",",$_REQUEST['selected_branch_id']);
		$credit_amount_daily=explode(",",$_REQUEST['credit_amount_daily']);
		$credit_amount_weekly=explode(",",$_REQUEST['credit_amount_weekly']);
		$credit_amount_monthly=explode(",",$_REQUEST['credit_amount_monthly']);
		
		$credit_member=explode(",",$_REQUEST['credit_member']);
		
		$debit_amount_daily=explode(",",$_REQUEST['debit_amount_daily']);
		$debit_amount_weekly=explode(",",$_REQUEST['debit_amount_weekly']);
		$debit_amount_monthly=explode(",",$_REQUEST['debit_amount_monthly']);
		
		$debit_member=explode(",",$_REQUEST['debit_member']);
		$saving_balance=explode(",",$_REQUEST['saving_balance']);
		if(count($center)>0){
			for($i=0;$i<count($center);$i++){
				
				$data=array(
						'area_id'=>$area[$i],
						'zone_id'=>$zone[$i],
						'branch_id'=>$branch[$i],
						'center_id'=>$center[$i],
						'date'=>$_REQUEST['date'],
						'credit_amount_daily'=>$credit_amount_daily[$i],
						'credit_amount_weekly'=>$credit_amount_weekly[$i],
						'credit_amount_monthly'=>$credit_amount_monthly[$i],
						'no_credit'=>$credit_member[$i],
						'debit_amount_daily'=>$debit_amount_daily[$i],
						'debit_amount_weekly'=>$debit_amount_weekly[$i],
						'debit_amount_monthly'=>$debit_amount_monthly[$i],
						'no_debit'=>$debit_member[$i],
						'balance'=>$saving_balance[$i]
						);
						$this->db->insert("saving_cash_register",$data);
						$id[]=$this->db->insert_id();
			}
		}
		if(count($id)>0){
			$array = array('status' => 'success', 'error' => '', 'message' => 'Saving Cash register posted successfullt for date '.date("y/m/d",strtotime($_REQUEST['date'])));
			echo json_encode($array);
		}
		else{
			$array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
		}*/
		
	}
	function add_dps_register(){
		$center=explode(",",$_REQUEST['selected_center_id']);
		$area=explode(",",$_REQUEST['selected_area_id']);
		$zone=explode(",",$_REQUEST['selected_zone_id']);
		
		$branch=explode(",",$_REQUEST['selected_branch_id']);
		$credit_amount=explode(",",$_REQUEST['credit_amount']);
	////	$credit_amount_weekly=explode(",",$_REQUEST['credit_amount_weekly']);
		//$credit_amount_monthly=explode(",",$_REQUEST['credit_amount_monthly']);
		
		$credit_member=explode(",",$_REQUEST['credit_member']);
		
		$debit_amount=explode(",",$_REQUEST['debit_amount']);
		//$debit_amount_weekly=explode(",",$_REQUEST['debit_amount_weekly']);
	//	$debit_amount_monthly=explode(",",$_REQUEST['debit_amount_monthly']);
		
		$debit_member=explode(",",$_REQUEST['debit_member']);
		//$saving_balance=explode(",",$_REQUEST['saving_balance']);
		if(count($center)>0){
			for($i=0;$i<count($center);$i++){
				
				$data=array(
						'area_id'=>$area[$i],
						'zone_id'=>$zone[$i],
						'branch_id'=>$branch[$i],
						'center_id'=>$center[$i],
						'date'=>$_REQUEST['date'],
						'credit_amount'=>$credit_amount[$i],
						//'credit_amount_weekly'=>$credit_amount_weekly[$i],
					//	'credit_amount_monthly'=>$credit_amount_monthly[$i],
						'no_credit'=>$credit_member[$i],
						'debit_amount'=>$debit_amount[$i],
					//	'debit_amount_weekly'=>$debit_amount_weekly[$i],
					//	'debit_amount_monthly'=>$debit_amount_monthly[$i],
						'no_debit'=>$debit_member[$i],
					//	'balance'=>$saving_balance[$i]
						);
						$this->db->insert("dps_cash_register",$data);
						$id[]=$this->db->insert_id();
			}
		}
		if(count($id)>0){
			$array = array('status' => 'success', 'error' => '', 'message' => 'Saving Cash register posted successfullt for date '.date("y/m/d",strtotime($_REQUEST['date'])));
			echo json_encode($array);
		}
		else{
			$array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
		}
		
	}
	function load_dps_cash(){
		
		global $global_config, $sesGroupId, $sesEmployerId;
		$PERPAGE_COUNT=100;
		$date=date("Y-m-d");
		$date=$_REQUEST['date'];
        list ($START_PAGE, $PERPAGE_COUNT) = common::getPosStartAndCountPerPage();
		$cond=" where 1 and b.date='{$date}'";
		/*if($_REQUEST['branch'])
			$cond.=" and b.branch_id in ({$_REQUEST['branch']})";
		if($_REQUEST['center'])
			$cond.=" and b.center_id in ({$_REQUEST['center']})";*/
		if ($_REQUEST['branch']) 
		{
			 $cond.="and b.branch_id='{$_REQUEST['branch']}'";
		}
		else{
			if(!common::is_super()&&$this->session->userdata("branch_id")!=""){
				$cond.=" and b.branch_id in('".$this->session->userdata("branch_id")."')";
			}
		}
		
		if ($_REQUEST['center']) {
			$cond.=" and b.center_id in ({$_REQUEST['center']})";
		}
		else{
			if(!common::is_super()&&$this->session->userdata("center_id")!=""){
				$cond.=" and b.center_id in(".$this->session->userdata("center_id").")";
			}
		}
			$query=$this->db->query("select b.date,b.center_id,b.zone_id,b.area_id,b.branch_id,branch.branch_name,center.center_name,center.center_no,sum(dpsc.amount) as credit_amount, count(dps.member_id) as credit_member, sum(dpsd.amount) as debit_amount,count(dps_withdraw.member_id) as debit_member
			
			from balance b 
			left join dps_account_transaction as dpsc on (dpsc.transaction_id=b.dps_transaction_id and dpsc.transaction_type=1)
			
			
			left join dps_account_transaction as dpsd on (dpsd.transaction_id=b.dps_transaction_id and dpsd.transaction_type=2)
			
			
			
			left join dps_account_transaction as dps on (dps.transaction_id=b.dps_transaction_id and dps.transaction_type=1)
			
			
			
			left join dps_account_transaction as dps_withdraw on (dps_withdraw.transaction_id=b.dps_transaction_id and dps_withdraw.transaction_type=2  )
			left join dps_account as s on (s.account_id=b.dps_account_id)
			left join branch on branch.branch_id=b.branch_id
			left join center on center.center_id=b.center_id $cond
			group by b.date,b.branch_id,b.center_id 
			having (
			credit_amount is not null
			or debit_amount is not null
			)
			order by b.date desc");
			
		$QryResult=$query->result_array();
		$TotalRec = $query->num_rows();
		ob_clean();
		header("Content-type:text/xml");
		$strXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
		$strXml .= "<rows total_count=\"" . $TotalRec . "\" pos=\"" . $START_PAGE . "\">\n";
		 if (!empty($TotalRec)) {
            for ($i = 0; $i < $TotalRec; $i++) {
                #$rowStatus = 1; 
				$status="";
				$row=sql::row("dps_cash_register","date='{$date}' and center_id='".$QryResult[$i]['center_id']."' and branch_id='".$QryResult[$i]['branch_id']."' and zone_id='".$QryResult[$i]['zone_id']."' and area_id='".$QryResult[$i]['area_id']."'");
				if(count($row)>0)
					$QryResult[$i]["DISABLED"] = 1;
				else{
					$QryResult[$i]["DISABLED"] = 0;
				}
				if(count($row)>0 && $row['status']==0)
					$status="Posted";
				if($QryResult[$i]['credit_amount']=="")
					$QryResult[$i]['credit_amount']=0;
				
				//$QryResult[$i]['total_credit']=$QryResult[$i]['credit_amount_daily']+$QryResult[$i]['credit_amount_weekly']+$QryResult[$i]['credit_amount_monthly'];
				
				if($QryResult[$i]['credit_member']=="")
					$QryResult[$i]['credit_member']=0;
				
				if($QryResult[$i]['debit_amount']=="")
					$QryResult[$i]['debit_amount']=0;
			//	if($QryResult[$i]['debit_amount_weekly']=="")
				//	$QryResult[$i]['debit_amount_weekly']=0;
				//if($QryResult[$i]['debit_amount_monthly']=="")
				//	$QryResult[$i]['debit_amount_monthly']=0;
				
			//	$QryResult[$i]['total_debit']=$QryResult[$i]['debit_amount_daily']+$QryResult[$i]['debit_amount_weekly']+$QryResult[$i]['debit_amount_monthly'];
				
				if($QryResult[$i]['debit_member']=="")
					$QryResult[$i]['debit_member']=0;
				//if($QryResult[$i]['saving_balance']=="")
				//	$QryResult[$i]['saving_balance']=0;
				
				
                $strXml .= "<row id=\"" . $i . "\">\n";
				$strXml .= "\t\t<cell></cell>\n";
                $strXml .= "<cell><![CDATA[" .  $QryResult [$i]['branch_name'] . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['center_no'] . "(".$QryResult[$i]['center_name'].")]]></cell>\n";
                $strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['credit_amount'],2,'.',',') . "]]></cell>\n";
				
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['credit_member'] . "]]></cell>\n";
				$strXml .= "<cell><![CDATA[" . number_format($QryResult[$i]['debit_amount'],2,'.',',') . "]]></cell>\n";
				
				$strXml .= "<cell><![CDATA[" . $QryResult[$i]['debit_member'] . "]]></cell>\n";
				//$strXml .= "<cell ><![CDATA[" .  number_format($QryResult[$i]['saving_balance'],2,'.',',') . "]]></cell>\n";
				$strXml .= "<cell ><![CDATA[" .  $status . "]]></cell>\n";
				$strXml .= "<userdata name=\"area_id\">" .  $QryResult[$i]['area_id'] . "</userdata>";
				$strXml .= "<userdata name=\"branch_id\">" .  $QryResult[$i]['branch_id'] . "</userdata>";
				$strXml .= "<userdata name=\"zone_id\">" .  $QryResult[$i]['zone_id'] . "</userdata>";
				$strXml .= "<userdata name=\"center_id\">" .  $QryResult[$i]['center_id'] . "</userdata>";
				$strXml .= "<userdata name=\"credit_amount\">" .  $QryResult[$i]['credit_amount'] . "</userdata>";
				
				
				$strXml .= "<userdata name=\"credit_member\">" .  $QryResult[$i]['credit_member'] . "</userdata>";
				
				$strXml .= "<userdata name=\"debit_amount\">" .  $QryResult[$i]['debit_amount'] . "</userdata>";
				
				
				$strXml .= "<userdata name=\"debit_member\">" .  $QryResult[$i]['debit_member'] . "</userdata>";
			//	$strXml .= "<userdata name=\"saving_balance\">" .  $QryResult[$i]['saving_balance'] . "</userdata>";
				$strXml .= "<userdata name=\"DISABLED_FIELD\">" .  $QryResult[$i]['DISABLED'] . "</userdata>";
				
                $strXml .= "</row>";  
            }
            
        } else {
            $strXml .= "<row id=\"0\">\n";
            $strXml .= "<cell colspan=\"8\" type=\"ro\"  align=\"center\"><![CDATA[<b>No Records Found</b>]]></cell>\n";
            $strXml .= "</row>";
        }
        $strXml .= "</rows>";

        print $strXml;
        exit ();
	}
	function cash_register_loan(){
		$query=$this->db->query("SELECT b.date,b.center_id,b.zone_id,b.area_id,b.branch_id,
branch.branch_name,

center.center_name,center.center_no,
count(loan_close.loan_id) as close_loan,
SUM(ltd.amount) AS loan_transaction_amount_daily,
SUM(ltw.amount) AS loan_transaction_amount_weekly,
SUM(ltm.amount) AS loan_transaction_amount_monthly, 
COUNT(lt.member_id) AS transaction_beneficiary, 
SUM(ld.loan_amount) AS loan_amount_daily,
SUM(ld.return_amount) AS return_amount_daily,
SUM(ld.opening_balance) AS loan_amount_daily_opening,
SUM(lw.loan_amount) AS loan_amount_weekly,
SUM(lw.return_amount) AS return_amount_weekly,
SUM(lw.opening_balance) AS loan_amount_weekly_opening,
SUM(lm.return_amount) AS return_amount_monthly,
SUM(lm.loan_amount) AS loan_amount_monthly,
SUM(lm.opening_balance) AS loan_amount_monthly_opening,
SUM(ld.service_charge_amount) AS daily_service_charge,
SUM(lw.service_charge_amount) AS weekly_service_charge,
SUM(lm.service_charge_amount) AS monthly_service_charge,
COUNT(ld.member_id) AS beneficiary_daily,
COUNT(lw.member_id) AS beneficiary_weekly,
COUNT(lm.member_id) AS beneficiary_monthly
FROM balance b 

LEFT JOIN loan ON loan.loan_id=b.loan_account_id and loan.loan_id
LEFT JOIN loan as loan_close ON loan_close.loan_id=b.loan_account_id and  loan_close.close_date=b.date
LEFT JOIN loan_transaction AS lt ON (lt.transaction_id=b.loan_transaction_id AND loan.loan_id=lt.loan_id AND loan.status=1)
LEFT JOIN loan_transaction AS ltd ON (ltd.transaction_id=b.loan_transaction_id AND ltd.account_type=1 
AND  b.loan_account_id=ltd.loan_id  and loan.loan_id=b.loan_account_id)
LEFT JOIN loan_transaction AS ltw ON (ltw.transaction_id=b.loan_transaction_id AND ltw.account_type=2 
 AND b.loan_account_id=ltw.loan_id and loan.loan_id=b.loan_account_id)
LEFT JOIN loan_transaction AS ltm ON (ltm.transaction_id=b.loan_transaction_id AND ltm.account_type=3
 )
LEFT JOIN loan AS ld ON (ld.loan_id=b.loan_id AND ld.loan_type=1 )
LEFT JOIN loan AS lw ON (lw.loan_id=b.loan_id AND lw.loan_type=2 )
LEFT JOIN loan AS lm ON (lm.loan_id=b.loan_id AND lm.loan_type=3 )
LEFT JOIN branch ON branch.branch_id=b.branch_id
LEFT JOIN center ON center.center_id=b.center_id 
			

WHERE 1 
GROUP BY b.date,b.branch_id,b.center_id   
			HAVING (
			
			loan_amount_daily IS NOT NULL
			OR loan_amount_weekly IS NOT NULL
			OR loan_amount_monthly IS NOT NULL
			OR loan_transaction_amount_daily IS NOT NULL
			OR loan_transaction_amount_weekly IS NOT NULL
			OR loan_transaction_amount_monthly IS NOT NULL
			or loan_amount_daily_opening is NOT NULL
			or loan_amount_weekly_opening is NOT NULL
			or loan_amount_monthly_opening is NOT NULL
			or close_loan is NOT NULL
			) ORDER BY b.date DESC");
			$rows=$query->result_array();
			foreach($rows as $row){
				
				$area_id=$row['area_id'];
				$zone_id=$row['zone_id'];
				$branch_id=$row['branch_id'];
				$center_id=$row['center_id'];
				$date=$row['date'];	
				$check_row=sql::row("loan_cash_register","date='{$date}' and center_id='".$row['center_id']."' and branch_id='".$row['branch_id']."' and zone_id='".$row['zone_id']."' and area_id='".$row['area_id']."'","id");
				//print_r($check_row);
				//echo count($check_row);
				$beneficiary=$row['beneficiary_daily']+$row['beneficiary_weekly']+$row['beneficiary_monthly'];
				$loan_amount_daily=$row['loan_amount_daily'];
				$loan_amount_weekly=$row['loan_amount_weekly'];
				$loan_amount_monthly=$row['loan_amount_monthly'];
				$daily_service_charge=$row['daily_service_charge'];
				$weekly_service_charge=$row['weekly_service_charge'];
				$monthly_service_charge=$row['monthly_service_charge'];
				$loan_close=$row['close_loan'];
				$no_loan_member=$beneficiary; 
				if($row['loan_amount_daily_opening']>0)
				$loan_collection_daily=$row['loan_transaction_amount_daily']+$row['return_amount_daily']-$row['loan_amount_daily_opening'];
			else{
				$loan_collection_daily=$row['loan_transaction_amount_daily'];
			}
			if($row['loan_amount_weekly_opening']>0)
				$loan_collection_weekly=$row['loan_transaction_amount_weekly']+$row['return_amount_weekly']-$row['loan_amount_weekly_opening'];
				
			else
				$loan_collection_weekly=$row['loan_transaction_amount_weekly'];
			if($row['loan_amount_monthly_opening']>0)
				$loan_collection_monthly=$row['loan_transaction_amount_monthly']+$row['return_amount_monthly']-$row['loan_amount_monthly_opening'];
			else
				$loan_collection_monthly=$row['loan_transaction_amount_monthly'];
				$no_collection_member=$row['transaction_beneficiary'];
				if(count($check_row)==0)
				$this->db->query("insert into loan_cash_register set area_id='{$area_id}',zone_id='{$zone_id}',branch_id={$branch_id},center_id='{$center_id}',date='{$date}',loan_amount_daily='{$loan_amount_daily}',loan_amount_weekly='{$loan_amount_weekly}',loan_amount_monthly='{$loan_amount_monthly}',daily_service_charge='{$daily_service_charge}',weekly_service_charge='{$weekly_service_charge}',monthly_service_charge='{$monthly_service_charge}',no_loan_member='{$no_loan_member}',loan_collection_daily='{$loan_collection_daily}',loan_collection_weekly='{$loan_collection_weekly}',loan_collection_monthly='{$loan_collection_monthly}',no_collection_member='{$no_collection_member}',loan_close='{$loan_close}'");
			}
	}
}

?>